/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;

public class TinkerItemDisplays {
    public static ItemDisplayContext MELTER = ToolModel.registerSmallTool(TinkerItemDisplays.create("melter", ItemDisplayContext.NONE));
    public static ItemDisplayContext TABLE = TinkerItemDisplays.create("table", ItemDisplayContext.NONE);
    public static ItemDisplayContext CASTING_TABLE = ToolModel.registerSmallTool(TinkerItemDisplays.create("casting_table", ItemDisplayContext.FIXED));
    public static ItemDisplayContext CASTING_BASIN = ToolModel.registerSmallTool(TinkerItemDisplays.create("casting_basin", ItemDisplayContext.NONE));

    private TinkerItemDisplays() {
    }

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TinkerItemDisplays::registerDisplay);
    }

    private static ItemDisplayContext create(String name, ItemDisplayContext fallback) {
        String key = "TCONSTRUCT_" + name.toUpperCase(Locale.ROOT);
        if (fallback == ItemDisplayContext.NONE) {
            return ItemDisplayContext.create((String)key, (ResourceLocation)TConstruct.getResource(name), null);
        }
        return ItemDisplayContext.create((String)key, (ResourceLocation)TConstruct.getResource(name), (ItemDisplayContext)fallback);
    }

    private static void registerDisplay(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.Keys.DISPLAY_CONTEXTS) {
            IForgeRegistry registry = (IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get();
            TinkerItemDisplays.register((IForgeRegistry<ItemDisplayContext>)registry, MELTER);
            TinkerItemDisplays.register((IForgeRegistry<ItemDisplayContext>)registry, TABLE);
            TinkerItemDisplays.register((IForgeRegistry<ItemDisplayContext>)registry, CASTING_TABLE);
            TinkerItemDisplays.register((IForgeRegistry<ItemDisplayContext>)registry, CASTING_BASIN);
        }
    }

    private static void register(IForgeRegistry<ItemDisplayContext> registry, ItemDisplayContext context) {
        registry.register(new ResourceLocation(context.m_7912_()), (Object)context);
    }
}

