/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.fluids;

import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import slimeknights.mantle.fluid.texture.ClientTextureFluidType;
import slimeknights.tconstruct.fluids.TinkerFluids;

public class PotionFluidType
extends FluidType {
    public PotionFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public String getDescriptionId(FluidStack stack) {
        return PotionUtils.m_43577_((CompoundTag)stack.getTag()).m_43492_("item.minecraft.potion.effect.");
    }

    public ItemStack getBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
        itemStack.m_41751_(fluidStack.getTag());
        return itemStack;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept((IClientFluidTypeExtensions)new ClientTextureFluidType(this){

            public int getTintColor(FluidStack stack) {
                CompoundTag tag = stack.getTag();
                if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
                    return tag.m_128451_("CustomPotionColor") | 0xFF000000;
                }
                if (PotionUtils.m_43577_((CompoundTag)tag) == Potions.f_43598_) {
                    return this.getTintColor();
                }
                return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000;
            }
        });
    }

    public static FluidStack potionFluid(Potion potion, int size) {
        CompoundTag tag = null;
        if (potion != Potions.f_43598_) {
            tag = new CompoundTag();
            tag.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)potion).toString());
        }
        return new FluidStack(TinkerFluids.potion.get(), size, tag);
    }
}

