/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.block.BurningLiquidBlock;
import slimeknights.tconstruct.fluids.block.MobEffectLiquidBlock;
import slimeknights.tconstruct.fluids.data.FluidBlockstateModelProvider;
import slimeknights.tconstruct.fluids.data.FluidBucketModelProvider;
import slimeknights.tconstruct.fluids.data.FluidTextureProvider;
import slimeknights.tconstruct.fluids.data.FluidTooltipProvider;
import slimeknights.tconstruct.fluids.fluids.PotionFluidType;
import slimeknights.tconstruct.fluids.fluids.SlimeFluid;
import slimeknights.tconstruct.fluids.item.BottleItem;
import slimeknights.tconstruct.fluids.item.ContainerFoodItem;
import slimeknights.tconstruct.fluids.item.PotionBucketItem;
import slimeknights.tconstruct.fluids.util.BottleBrewingRecipe;
import slimeknights.tconstruct.fluids.util.EmptyBottleIntoEmpty;
import slimeknights.tconstruct.fluids.util.EmptyBottleIntoWater;
import slimeknights.tconstruct.fluids.util.FillBottle;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.network.FluidDataSerializer;
import slimeknights.tconstruct.world.TinkerWorld;

public final class TinkerFluids
extends TinkerModule {
    public static final RegistryObject<CreativeModeTab> tabFluids = CREATIVE_TABS.register("fluids", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "fluids")).m_257737_(() -> new ItemStack(moltenIron)).m_257501_(TinkerFluids::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerSmeltery.tabSmeltery.getId()}).m_257652_());
    public static final FlowingFluidObject<ForgeFlowingFluid> venom = FLUIDS.register("venom").type(TinkerFluids.slime("venom").temperature(310)).bucket().block(MobEffectLiquidBlock.createEffect(MapColor.f_283942_, 0, () -> new MobEffectInstance(MobEffects.f_19614_, 100))).flowing();
    public static final ItemObject<Item> venomBottle = ITEMS.register("venom_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(TinkerFood.VENOM_BOTTLE).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack(venom.get(), 250)));
    public static final FluidObject<UnplaceableFluid> powderedSnow = ((FluidDeferredRegister.Builder)FLUIDS.register("powdered_snow").bucket(() -> Items.f_151055_)).type(TinkerFluids.powder("powdered_snow").temperature(270)).unplacable();
    public static final FlowingFluidObject<SlimeFluid> earthSlime = FLUIDS.register("earth_slime").type(TinkerFluids.slime("earth_slime").temperature(350)).bucket().block(MobEffectLiquidBlock.createEffect(MapColor.f_283824_, 0, () -> new MobEffectInstance(MobEffects.f_19621_, 100))).tagName("slime").flowing(SlimeFluid.Source::new, SlimeFluid.Flowing::new);
    public static final FlowingFluidObject<SlimeFluid> skySlime = FLUIDS.register("sky_slime").type(TinkerFluids.slime("sky_slime").temperature(310)).bucket().block(MobEffectLiquidBlock.createEffect(MapColor.f_283821_, 0, () -> new MobEffectInstance(MobEffects.f_19603_, 100))).flowing(SlimeFluid.Source::new, SlimeFluid.Flowing::new);
    public static final FlowingFluidObject<SlimeFluid> enderSlime = FLUIDS.register("ender_slime").type(TinkerFluids.slime("ender_slime").temperature(370)).bucket().block(MobEffectLiquidBlock.createEffect(MapColor.f_283889_, 0, () -> new MobEffectInstance((MobEffect)TinkerModifiers.enderferenceEffect.get(), 100))).flowing(SlimeFluid.Source::new, SlimeFluid.Flowing::new);
    public static final FlowingFluidObject<SlimeFluid> magma = FLUIDS.register("magma").type(TinkerFluids.slime("magma").temperature(600).lightLevel(3)).bucket().block(BurningLiquidBlock.createBurning(MapColor.f_283820_, 3, 8, 3.0f)).flowing(SlimeFluid.Source::new, SlimeFluid.Flowing::new);
    public static final EnumObject<SlimeType, SlimeFluid> slime = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, earthSlime).put((Enum)SlimeType.SKY, skySlime).put((Enum)SlimeType.ENDER, enderSlime).build();
    public static final EnumObject<SlimeType, Item> slimeBottle = new EnumObject.Builder(SlimeType.class).putAll(ITEMS.registerEnum(SlimeType.LIQUID, "slime_bottle", type -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(TinkerFood.getBottle(type)).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)slime.get((Enum)type), 250)))).put((Enum)SlimeType.ICHOR, (Supplier)ITEMS.register("ichor_slime_bottle", () -> new ContainerFoodItem(new Item.Properties().m_41489_(TinkerFood.ICHOR_BOTTLE).m_41487_(1).m_41495_(Items.f_42590_)))).build();
    public static final ItemObject<Item> magmaBottle = ITEMS.register("magma_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(TinkerFood.MAGMA_BOTTLE).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack(magma.get(), 250)));
    public static FlowingFluidObject<ForgeFlowingFluid> honey = FLUIDS.register("honey").type(TinkerFluids.slime("honey").temperature(301)).bucket().block(MobEffectLiquidBlock.createEffect(MapColor.f_283750_, 0, () -> new MobEffectInstance(MobEffects.f_19597_, 100))).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> beetrootSoup = FLUIDS.register("beetroot_soup").type(TinkerFluids.cool("beetroot_soup").temperature(400)).bucket().block(MapColor.f_283913_, 0).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> mushroomStew = FLUIDS.register("mushroom_stew").type(TinkerFluids.cool("mushroom_stew").temperature(400)).bucket().block(MapColor.f_283762_, 0).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> rabbitStew = FLUIDS.register("rabbit_stew").type(TinkerFluids.cool("rabbit_stew").temperature(400)).bucket().block(MapColor.f_283819_, 0).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> meatSoup = FLUIDS.register("meat_soup").type(TinkerFluids.cool("meat_soup").temperature(400)).bucket().block(MapColor.f_283909_, 0).flowing();
    public static final ItemObject<Item> meatSoupBowl = ITEMS.register("meat_soup", () -> new ContainerFoodItem(new Item.Properties().m_41489_(TinkerFood.MEAT_SOUP).m_41487_(1).m_41495_(Items.f_42399_)));
    public static final FluidObject<UnplaceableFluid> potion = FLUIDS.register("potion").type(() -> new PotionFluidType(TinkerFluids.cool().descriptionId("item.minecraft.potion.effect.empty").density(1100).viscosity(1100).temperature(315))).bucket(fluid -> new PotionBucketItem((Supplier<? extends Fluid>)fluid, RegistrationHelper.BUCKET_PROPS)).unplacable();
    public static final ItemObject<Item> splashBottle = ITEMS.register("splash_bottle", () -> new BottleItem((ItemLike)Items.f_42736_, ITEM_PROPS));
    public static final ItemObject<Item> lingeringBottle = ITEMS.register("lingering_bottle", () -> new BottleItem((ItemLike)Items.f_42739_, ITEM_PROPS));
    public static final FlowingFluidObject<ForgeFlowingFluid> searedStone = FLUIDS.register("seared_stone").type(TinkerFluids.hot("seared_stone").temperature(900).lightLevel(6)).block(BurningLiquidBlock.createBurning(MapColor.f_283875_, 6, 8, 2.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> scorchedStone = FLUIDS.register("scorched_stone").type(TinkerFluids.hot("scorched_stone").temperature(800).lightLevel(4)).block(BurningLiquidBlock.createBurning(MapColor.f_283774_, 4, 7, 2.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenClay = FLUIDS.register("molten_clay").type(TinkerFluids.hot("molten_clay").temperature(750).lightLevel(3)).block(BurningLiquidBlock.createBurning(MapColor.f_283750_, 3, 5, 2.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenGlass = FLUIDS.register("molten_glass").type(TinkerFluids.hot("molten_glass").temperature(1050).lightLevel(1)).block(BurningLiquidBlock.createBurning(MapColor.f_283828_, 1, 5, 2.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> liquidSoul = FLUIDS.register("liquid_soul").type(TinkerFluids.hot("liquid_soul").temperature(700).lightLevel(2)).block(MobEffectLiquidBlock.createEffect(MapColor.f_283748_, 2, () -> new MobEffectInstance(MobEffects.f_19610_, 100))).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenPorcelain = FLUIDS.register("molten_porcelain").type(TinkerFluids.hot("molten_porcelain").temperature(1000).lightLevel(2)).block(BurningLiquidBlock.createBurning(MapColor.f_283942_, 2, 5, 2.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenObsidian = FLUIDS.register("molten_obsidian").type(TinkerFluids.hot("molten_obsidian").temperature(1300).lightLevel(3)).block(BurningLiquidBlock.createBurning(MapColor.f_283927_, 3, 12, 4.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenEnder = FLUIDS.register("molten_ender").type(TinkerFluids.hot("molten_ender").temperature(777).lightLevel(5)).block(MobEffectLiquidBlock.createEffect(MapColor.f_283915_, 5, () -> new MobEffectInstance((MobEffect)TinkerModifiers.enderferenceEffect.get(), 100))).bucket().tagName("ender").flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> blazingBlood = FLUIDS.register("blazing_blood").type(TinkerFluids.hot("blazing_blood").temperature(1800).lightLevel(15).density(3500)).block(BurningLiquidBlock.createBurning(MapColor.f_283750_, 15, 15, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenEmerald = FLUIDS.register("molten_emerald").type(TinkerFluids.hot("molten_emerald").temperature(1234).lightLevel(9)).block(BurningLiquidBlock.createBurning(MapColor.f_283812_, 9, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenQuartz = FLUIDS.register("molten_quartz").type(TinkerFluids.hot("molten_quartz").temperature(937).lightLevel(6)).block(BurningLiquidBlock.createBurning(MapColor.f_283942_, 6, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenAmethyst = FLUIDS.register("molten_amethyst").type(TinkerFluids.hot("molten_amethyst").temperature(1250).lightLevel(11)).block(BurningLiquidBlock.createBurning(MapColor.f_283889_, 11, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenDiamond = FLUIDS.register("molten_diamond").type(TinkerFluids.hot("molten_diamond").temperature(1750).lightLevel(13)).block(BurningLiquidBlock.createBurning(MapColor.f_283821_, 13, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenDebris = FLUIDS.register("molten_debris").type(TinkerFluids.hot("molten_debris").temperature(1475).lightLevel(14)).block(BurningLiquidBlock.createBurning(MapColor.f_283927_, 14, 10, 8.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenIron = FLUIDS.register("molten_iron").type(TinkerFluids.hot("molten_iron").temperature(1100).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283877_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenGold = FLUIDS.register("molten_gold").type(TinkerFluids.hot("molten_gold").temperature(1000).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283757_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenCopper = FLUIDS.register("molten_copper").type(TinkerFluids.hot("molten_copper").temperature(800).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283750_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenCobalt = FLUIDS.register("molten_cobalt").type(TinkerFluids.hot("molten_cobalt").temperature(1250).lightLevel(8)).block(BurningLiquidBlock.createBurning(MapColor.f_283864_, 8, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenSlimesteel = FLUIDS.register("molten_slimesteel").type(TinkerFluids.hot("molten_slimesteel").temperature(1200).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283821_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenAmethystBronze = FLUIDS.register("molten_amethyst_bronze").type(TinkerFluids.hot("molten_amethyst_bronze").temperature(1120).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283931_, 12, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenRoseGold = FLUIDS.register("molten_rose_gold").type(TinkerFluids.hot("molten_rose_gold").temperature(850).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283765_, 12, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenPigIron = FLUIDS.register("molten_pig_iron").type(TinkerFluids.hot("molten_pig_iron").temperature(1111).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283919_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenManyullyn = FLUIDS.register("molten_manyullyn").type(TinkerFluids.hot("molten_manyullyn").temperature(1500).lightLevel(11)).block(BurningLiquidBlock.createBurning(MapColor.f_283889_, 11, 10, 8.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenHepatizon = FLUIDS.register("molten_hepatizon").type(TinkerFluids.hot("molten_hepatizon").temperature(1700).lightLevel(8)).block(BurningLiquidBlock.createBurning(MapColor.f_283908_, 8, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenQueensSlime = FLUIDS.register("molten_queens_slime").type(TinkerFluids.hot("molten_queens_slime").temperature(1450).lightLevel(9)).block(BurningLiquidBlock.createBurning(MapColor.f_283784_, 9, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenSoulsteel = FLUIDS.register("molten_soulsteel").type(TinkerFluids.hot("molten_soulsteel").temperature(1500).lightLevel(6)).block(BurningLiquidBlock.createBurning(MapColor.f_283748_, 6, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenNetherite = FLUIDS.register("molten_netherite").type(TinkerFluids.hot("molten_netherite").temperature(1550).lightLevel(14)).block(BurningLiquidBlock.createBurning(MapColor.f_283927_, 14, 10, 10.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenKnightslime = FLUIDS.register("molten_knightslime").type(TinkerFluids.hot("molten_knightslime").temperature(1425).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283931_, 12, 10, 8.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenTin = FLUIDS.register("molten_tin").type(TinkerFluids.hot("molten_tin").temperature(525).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283772_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenAluminum = FLUIDS.register("molten_aluminum").type(TinkerFluids.hot("molten_aluminum").temperature(725).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283906_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenLead = FLUIDS.register("molten_lead").type(TinkerFluids.hot("molten_lead").temperature(630).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283908_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenSilver = FLUIDS.register("molten_silver").type(TinkerFluids.hot("molten_silver").temperature(1090).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283906_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenNickel = FLUIDS.register("molten_nickel").type(TinkerFluids.hot("molten_nickel").temperature(1250).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283825_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenZinc = FLUIDS.register("molten_zinc").type(TinkerFluids.hot("molten_zinc").temperature(720).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283846_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenPlatinum = FLUIDS.register("molten_platinum").type(TinkerFluids.hot("molten_platinum").temperature(1270).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283821_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenTungsten = FLUIDS.register("molten_tungsten").type(TinkerFluids.hot("molten_tungsten").temperature(1250).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283771_, 12, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenOsmium = FLUIDS.register("molten_osmium").type(TinkerFluids.hot("molten_osmium").temperature(1275).lightLevel(4)).block(BurningLiquidBlock.createBurning(MapColor.f_283744_, 4, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenUranium = FLUIDS.register("molten_uranium").type(TinkerFluids.hot("molten_uranium").temperature(1130).lightLevel(15)).block(BurningLiquidBlock.createBurning(MapColor.f_283856_, 15, 10, 5.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenBronze = FLUIDS.register("molten_bronze").type(TinkerFluids.hot("molten_bronze").temperature(1000).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283895_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenBrass = FLUIDS.register("molten_brass").type(TinkerFluids.hot("molten_brass").temperature(905).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283843_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenElectrum = FLUIDS.register("molten_electrum").type(TinkerFluids.hot("molten_electrum").temperature(1060).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283757_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenInvar = FLUIDS.register("molten_invar").type(TinkerFluids.hot("molten_invar").temperature(1200).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283769_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenConstantan = FLUIDS.register("molten_constantan").type(TinkerFluids.hot("molten_constantan").temperature(1220).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283798_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenPewter = FLUIDS.register("molten_pewter").type(TinkerFluids.hot("molten_pewter").temperature(700).lightLevel(10)).block(BurningLiquidBlock.createBurning(MapColor.f_283818_, 10, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenSteel = FLUIDS.register("molten_steel").type(TinkerFluids.hot("molten_steel").temperature(1250).lightLevel(13)).block(BurningLiquidBlock.createBurning(MapColor.f_283947_, 13, 10, 6.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenEnderium = FLUIDS.register("molten_enderium").type(TinkerFluids.hot("molten_enderium").temperature(1650).lightLevel(12)).block(BurningLiquidBlock.createBurning(MapColor.f_283772_, 12, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenLumium = FLUIDS.register("molten_lumium").type(TinkerFluids.hot("molten_lumium").temperature(1350).lightLevel(15)).block(BurningLiquidBlock.createBurning(MapColor.f_283757_, 15, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenSignalum = FLUIDS.register("molten_signalum").type(TinkerFluids.hot("molten_signalum").temperature(1425).lightLevel(13)).block(BurningLiquidBlock.createBurning(MapColor.f_283816_, 13, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenRefinedGlowstone = FLUIDS.register("molten_refined_glowstone").type(TinkerFluids.hot("molten_refined_glowstone").temperature(1125).lightLevel(15)).block(BurningLiquidBlock.createBurning(MapColor.f_283832_, 15, 10, 7.0f)).bucket().flowing();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenRefinedObsidian = FLUIDS.register("molten_refined_obsidian").type(TinkerFluids.hot("molten_refined_obsidian").temperature(1775).lightLevel(7)).block(BurningLiquidBlock.createBurning(MapColor.f_283908_, 7, 10, 7.0f)).bucket().flowing();
    public static final FluidDataSerializer FLUID_DATA_SERIALIZER = new FluidDataSerializer();
    public static final RegistryObject<EntityDataSerializer<?>> FLUID_DATA_SERIALIZER_REGISTRY = DATA_SERIALIZERS.register("fluid", () -> FLUID_DATA_SERIALIZER);
    private static final int MOLTEN_LENGTH = "molten_".length();

    public TinkerFluids() {
        ForgeMod.enableMilkFluid();
    }

    private static FluidType.Properties cool() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).motionScale(0.0023333333333333335).canExtinguish(true);
    }

    private static FluidType.Properties cool(String name) {
        return TinkerFluids.cool().descriptionId(TConstruct.makeDescriptionId("fluid", name)).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }

    private static FluidType.Properties slime(String name) {
        return TinkerFluids.cool(name).density(1600).viscosity(1600);
    }

    private static FluidType.Properties powder(String name) {
        return FluidType.Properties.create().descriptionId(TConstruct.makeDescriptionId("fluid", name)).sound(SoundActions.BUCKET_FILL, SoundEvents.f_144089_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_144076_);
    }

    private static FluidType.Properties hot(String name) {
        return FluidType.Properties.create().density(2000).viscosity(10000).temperature(1000).descriptionId(TConstruct.makeDescriptionId("fluid", name)).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).motionScale(0.0023333333333333335).canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new FluidTooltipProvider(packOutput));
        generator.addProvider(client, (DataProvider)new FluidTextureProvider(packOutput));
        generator.addProvider(client, (DataProvider)new FluidBucketModelProvider(packOutput, "tconstruct"));
        generator.addProvider(client, (DataProvider)new FluidBlockstateModelProvider(packOutput, "tconstruct"));
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CauldronInteraction.f_175607_.put((Item)splashBottle.get(), new FillBottle(Items.f_42736_));
            CauldronInteraction.f_175607_.put((Item)lingeringBottle.get(), new FillBottle(Items.f_42739_));
            CauldronInteraction.f_175607_.put(Items.f_42736_, new EmptyBottleIntoWater((Supplier<Item>)splashBottle, (CauldronInteraction)CauldronInteraction.f_175607_.get(Items.f_42736_)));
            CauldronInteraction.f_175607_.put(Items.f_42739_, new EmptyBottleIntoWater((Supplier<Item>)lingeringBottle, (CauldronInteraction)CauldronInteraction.f_175607_.get(Items.f_42739_)));
            CauldronInteraction.f_175606_.put(Items.f_42736_, new EmptyBottleIntoEmpty((Supplier<Item>)splashBottle, (CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42736_)));
            CauldronInteraction.f_175606_.put(Items.f_42739_, new EmptyBottleIntoEmpty((Supplier<Item>)lingeringBottle, (CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42739_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Items.f_42589_, Items.f_42736_, new ItemStack(splashBottle)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_204132_(TinkerTags.Items.SPLASH_BOTTLE), Items.f_42736_, Items.f_42739_, new ItemStack(lingeringBottle)));
        });
        DefaultDispenseItemBehavior dispenseBucket = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                DispensibleContainerItem container = (DispensibleContainerItem)stack.m_41720_();
                BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = source.m_7727_();
                if (container.emptyContents(null, (Level)level, blockpos, null, stack)) {
                    container.m_142131_(null, (Level)level, stack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
        };
        event.enqueueWork(() -> TinkerFluids.lambda$commonSetup$24((DispenseItemBehavior)dispenseBucket));
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(splashBottle);
        output.m_246326_(lingeringBottle);
        output.m_246326_(earthSlime);
        output.m_246326_(skySlime);
        output.m_246326_(enderSlime);
        TinkerFluids.accept(output, slimeBottle);
        output.m_246326_(magma);
        output.m_246326_(magmaBottle);
        output.m_246326_(venom);
        output.m_246326_(venomBottle);
        output.m_246326_(honey);
        output.m_246326_(beetrootSoup);
        output.m_246326_(mushroomStew);
        output.m_246326_(rabbitStew);
        output.m_246326_(meatSoup);
        output.m_246326_(meatSoupBowl);
        output.m_246326_(searedStone);
        output.m_246326_(scorchedStone);
        output.m_246326_(moltenClay);
        if (ModList.get().isLoaded("ceramics")) {
            output.m_246326_(moltenPorcelain);
        }
        output.m_246326_(moltenGlass);
        output.m_246326_(moltenObsidian);
        output.m_246326_(liquidSoul);
        output.m_246326_(moltenEnder);
        output.m_246326_(blazingBlood);
        output.m_246326_(moltenEmerald);
        output.m_246326_(moltenQuartz);
        output.m_246326_(moltenAmethyst);
        output.m_246326_(moltenDiamond);
        output.m_246326_(moltenDebris);
        output.m_246326_(moltenCopper);
        output.m_246326_(moltenIron);
        output.m_246326_(moltenGold);
        output.m_246326_(moltenCobalt);
        output.m_246326_(moltenSlimesteel);
        output.m_246326_(moltenAmethystBronze);
        output.m_246326_(moltenRoseGold);
        output.m_246326_(moltenPigIron);
        output.m_246326_(moltenQueensSlime);
        output.m_246326_(moltenManyullyn);
        output.m_246326_(moltenHepatizon);
        output.m_246326_(moltenNetherite);
        TinkerFluids.acceptMolten(output, moltenTin);
        TinkerFluids.acceptMolten(output, moltenAluminum);
        TinkerFluids.acceptMolten(output, moltenLead);
        TinkerFluids.acceptMolten(output, moltenSilver);
        TinkerFluids.acceptMolten(output, moltenNickel);
        TinkerFluids.acceptMolten(output, moltenZinc);
        TinkerFluids.acceptMolten(output, moltenPlatinum);
        TinkerFluids.acceptMolten(output, moltenTungsten);
        TinkerFluids.acceptMolten(output, moltenOsmium);
        TinkerFluids.acceptMolten(output, moltenUranium);
        TinkerFluids.acceptMolten(output, moltenBronze, "tin");
        TinkerFluids.acceptMolten(output, moltenBrass, "zinc");
        TinkerFluids.acceptMolten(output, moltenElectrum, "silver");
        TinkerFluids.acceptMolten(output, moltenInvar, "nickel");
        TinkerFluids.acceptMolten(output, moltenConstantan, "nickel");
        TinkerFluids.acceptMolten(output, moltenPewter);
        TinkerFluids.acceptMolten(output, moltenSteel);
        TinkerFluids.acceptMolten(output, moltenEnderium);
        TinkerFluids.acceptMolten(output, moltenLumium);
        TinkerFluids.acceptMolten(output, moltenSignalum);
        TinkerFluids.acceptMolten(output, moltenRefinedGlowstone);
        TinkerFluids.acceptMolten(output, moltenRefinedObsidian);
        for (Fluid fluid : BuiltInRegistries.f_257020_) {
            if (!fluid.m_7444_(fluid.m_76145_())) continue;
            output.m_246267_(CopperCanItem.setFluid(new ItemStack(TinkerSmeltery.copperCan), fluid, null), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        for (Fluid fluid : BuiltInRegistries.f_257020_) {
            if (!fluid.m_7444_(fluid.m_76145_())) continue;
            output.m_246267_(TankItem.setTank(new ItemStack(TinkerSmeltery.searedLantern), new FluidStack(fluid, 50)), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            output.m_246267_(TankItem.setTank(new ItemStack(TinkerSmeltery.scorchedLantern), new FluidStack(fluid, 50)), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            SearedTankBlock.TankType tankType = fluid.m_205067_(TinkerTags.Fluids.METAL_TOOLTIPS) ? SearedTankBlock.TankType.INGOT_GAUGE : SearedTankBlock.TankType.FUEL_GAUGE;
            output.m_246267_(TinkerFluids.fillTank(TinkerSmeltery.searedTank, tankType, fluid), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            output.m_246267_(TinkerFluids.fillTank(TinkerSmeltery.scorchedTank, tankType, fluid), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
    }

    private static void acceptCompat(CreativeModeTab.Output output, ItemLike item, String ... ingots) {
        for (String ingot : ingots) {
            if (TinkerFluids.acceptIfTag(output, item, (TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ingots/" + ingot)))) break;
        }
    }

    private static void acceptMolten(CreativeModeTab.Output output, FluidObject<?> fluid) {
        TinkerFluids.acceptCompat(output, fluid, new String[]{TinkerFluids.withoutMolten(fluid)});
    }

    private static void acceptMolten(CreativeModeTab.Output output, FluidObject<?> fluid, String ingot) {
        TinkerFluids.acceptCompat(output, fluid, new String[]{TinkerFluids.withoutMolten(fluid), ingot});
    }

    public static String withoutMolten(FluidObject<?> fluid) {
        return fluid.getId().m_135815_().substring(MOLTEN_LENGTH);
    }

    public static ItemStack fillTank(EnumObject<SearedTankBlock.TankType, ? extends ItemLike> tank, SearedTankBlock.TankType type, Fluid fluid) {
        return TankItem.setTank(new ItemStack((ItemLike)tank.get((Enum)type)), new FluidStack(fluid, type.getCapacity()));
    }

    private static /* synthetic */ void lambda$commonSetup$24(DispenseItemBehavior dispenseBucket) {
        DispenserBlock.m_52672_(venom, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(earthSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(skySlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(enderSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(magma, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(honey, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(beetrootSoup, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(mushroomStew, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(rabbitStew, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(meatSoup, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(searedStone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(scorchedStone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenClay, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenGlass, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(liquidSoul, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPorcelain, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenObsidian, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEnder, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(blazingBlood, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEmerald, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenQuartz, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAmethyst, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenDiamond, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenDebris, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenIron, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenGold, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenCopper, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenCobalt, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSlimesteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAmethystBronze, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRoseGold, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPigIron, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenManyullyn, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenHepatizon, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenQueensSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSoulsteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenNetherite, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenKnightslime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenTin, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAluminum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenLead, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSilver, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenNickel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenZinc, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPlatinum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenTungsten, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenOsmium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenUranium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenBronze, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenBrass, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenElectrum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenInvar, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenConstantan, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPewter, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEnderium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenLumium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSignalum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRefinedGlowstone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRefinedObsidian, (DispenseItemBehavior)dispenseBucket);
        for (SlimeType slime : SlimeType.values()) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)slime)}), new ItemStack((ItemLike)slimeBottle.get((Enum)slime))));
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50450_}), new ItemStack(magmaBottle)));
    }
}

