/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.SkullBlock;

public enum TinkerHeadType implements SkullBlock.Type,
StringRepresentable
{
    BLAZE(() -> EntityType.f_20551_),
    ENDERMAN(() -> EntityType.f_20566_),
    STRAY(() -> EntityType.f_20481_),
    HUSK(() -> EntityType.f_20458_),
    DROWNED(() -> EntityType.f_20562_),
    SPIDER(() -> EntityType.f_20479_),
    CAVE_SPIDER(() -> EntityType.f_20554_),
    PIGLIN_BRUTE(() -> EntityType.f_20512_),
    ZOMBIFIED_PIGLIN(() -> EntityType.f_20531_),
    VENOMBONE(() -> EntityType.f_20524_),
    BLAZING_BONE(() -> EntityType.f_20497_),
    NECRONIUM(() -> EntityType.f_20497_);

    private final Supplier<EntityType<?>> type;

    public EntityType<?> getType() {
        return this.type.get();
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isPiglin() {
        return this == PIGLIN_BRUTE || this == ZOMBIFIED_PIGLIN;
    }

    public boolean isNatural() {
        return this != VENOMBONE && this != BLAZING_BONE && this != NECRONIUM;
    }

    @Nullable
    public static TinkerHeadType fromEntityType(EntityType<?> type) {
        for (TinkerHeadType headType : TinkerHeadType.values()) {
            if (!headType.isNatural() || headType.getType() != type) continue;
            return headType;
        }
        return null;
    }

    private TinkerHeadType(Supplier<EntityType<?>> type) {
        this.type = type;
    }
}

