/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe.severing;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;

public class SpecialSeveringRecipeBuilder
extends AbstractRecipeBuilder<SpecialSeveringRecipeBuilder> {
    private final RecipeSerializer<? extends SeveringRecipe> serializer;
    private float baseChance = 0.05f;
    private float lootingBonus = 0.01f;

    public static SpecialSeveringRecipeBuilder serializer(Supplier<? extends RecipeSerializer<? extends SeveringRecipe>> supplier) {
        return SpecialSeveringRecipeBuilder.serializer(supplier.get());
    }

    public SpecialSeveringRecipeBuilder rareMob() {
        this.baseChance = 0.1f;
        this.lootingBonus = 0.02f;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(BuiltInRegistries.f_256769_.m_7981_(this.serializer)));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept((FinishedRecipe)new Finished(id, null));
    }

    public SpecialSeveringRecipeBuilder setBaseChance(float baseChance) {
        this.baseChance = baseChance;
        return this;
    }

    public SpecialSeveringRecipeBuilder setLootingBonus(float lootingBonus) {
        this.lootingBonus = lootingBonus;
        return this;
    }

    private SpecialSeveringRecipeBuilder(RecipeSerializer<? extends SeveringRecipe> serializer) {
        this.serializer = serializer;
    }

    public static SpecialSeveringRecipeBuilder serializer(RecipeSerializer<? extends SeveringRecipe> serializer) {
        return new SpecialSeveringRecipeBuilder(serializer);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation id, ResourceLocation advancementId) {
            super((AbstractRecipeBuilder)SpecialSeveringRecipeBuilder.this, id, advancementId);
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("per_level_chance", (Number)Float.valueOf(SpecialSeveringRecipeBuilder.this.baseChance));
            json.addProperty("looting_bonus", (Number)Float.valueOf(SpecialSeveringRecipeBuilder.this.lootingBonus));
        }

        public RecipeSerializer<?> m_6637_() {
            return SpecialSeveringRecipeBuilder.this.serializer;
        }
    }
}

