/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record TankInteractionModule(@Nullable InteractionSource source) implements ModifierModule,
BlockInteractionModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BLOCK_INTERACT);
    public static final RecordLoadable<TankInteractionModule> LOADER = RecordLoadable.create((RecordField)TinkerLoadables.INTERACTION_SOURCE.nullableField("interaction_source", TankInteractionModule::source), TankInteractionModule::new);

    @Override
    public RecordLoadable<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public InteractionResult beforeBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        BlockPos target;
        if (this.source != null && this.source != source || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockEntity te = world.m_7702_(target = context.m_8083_());
        if (te == null) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        IFluidHandler cap = (IFluidHandler)LogicHelper.orElseNull((LazyOptional)te.getCapability(ForgeCapabilities.FLUID_HANDLER, face));
        if (cap == null) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Player player = context.m_43723_();
            boolean sneaking = player != null && player.m_6144_();
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid(tool);
            SoundEvent sound = null;
            if (sneaking) {
                int added;
                if (!fluidStack.isEmpty() && (added = cap.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    sound = FluidTransferHelper.getEmptySound((FluidStack)fluidStack);
                    fluidStack.shrink(added);
                    ToolTankHelper.TANK_HELPER.setFluid(tool, fluidStack);
                }
            } else if (fluidStack.isEmpty()) {
                FluidStack drained = cap.drain(ToolTankHelper.TANK_HELPER.getCapacity(tool), IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    ToolTankHelper.TANK_HELPER.setFluid(tool, drained);
                    sound = FluidTransferHelper.getFillSound((FluidStack)fluidStack);
                }
            } else {
                FluidStack drained = cap.drain(new FluidStack(fluidStack, ToolTankHelper.TANK_HELPER.getCapacity(tool) - fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty() && drained.isFluidEqual(fluidStack)) {
                    fluidStack.grow(drained.getAmount());
                    ToolTankHelper.TANK_HELPER.setFluid(tool, fluidStack);
                    sound = FluidTransferHelper.getFillSound((FluidStack)fluidStack);
                }
            }
            if (sound != null) {
                world.m_5594_(null, target, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

