/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public record SlurpingModule(LevelingValue strength, LevelingInt duration) implements ModifierModule,
GeneralInteractionModifierHook,
UsingToolModifierHook,
KeybindInteractModifierHook,
InventoryTickModifierHook,
EquipmentChangeModifierHook
{
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING, ModifierHooks.ARMOR_INTERACT, ModifierHooks.INVENTORY_TICK, ModifierHooks.EQUIPMENT_CHANGE);
    public static final RecordLoadable<SlurpingModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("strength", SlurpingModule::strength), (RecordField)LevelingInt.LOADABLE.requiredField("duration", SlurpingModule::duration), SlurpingModule::new);

    public RecordLoadable<SlurpingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private int slurp(FluidStack fluid, ModifierEntry entry, LivingEntity entity, @Nullable Player player, IFluidHandler.FluidAction action) {
        if (!fluid.isEmpty()) {
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            return recipe.hasEntityEffects() ? recipe.applyToEntity(fluid, this.strength.compute(entry), FluidEffectContext.builder(entity.m_9236_()).user(entity, player).target(entity), action) : 0;
        }
        return 0;
    }

    private void finishDrinking(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, boolean playSound) {
        FluidStack fluid = ToolTankHelper.TANK_HELPER.getFluid(tool);
        if (!fluid.isEmpty()) {
            Player player;
            int consumed;
            if (playSound) {
                entity.m_5496_(SoundEvents.f_11911_, 0.5f, entity.m_217043_().m_188501_() * 0.1f + 0.9f);
            }
            SlurpingModule.addFluidParticles(entity, fluid, 16);
            if (!(entity.m_9236_().f_46443_ || (consumed = this.slurp(fluid, modifier, entity, player = ModifierUtil.asPlayer((Entity)entity), IFluidHandler.FluidAction.EXECUTE)) <= 0 || player != null && player.m_7500_())) {
                fluid.shrink(consumed);
                ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
            }
        }
    }

    private static void addFluidParticles(LivingEntity entity, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            RandomSource random = entity.m_217043_();
            Vec3 motion = new Vec3(((double)random.m_188501_() - 0.5) * 0.1, (double)random.m_188501_() * 0.1 + 0.1, 0.0);
            motion = motion.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            motion = motion.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            Vec3 position = new Vec3(((double)random.m_188501_() - 0.5) * 0.3, (double)(-random.m_188501_()) * 0.6 - 0.3, 0.6);
            position = position.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            FluidParticleData data = new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid);
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && this.slurp(ToolTankHelper.TANK_HELPER.getFluid(tool), modifier, (LivingEntity)player, player, IFluidHandler.FluidAction.SIMULATE) > 0) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return this.duration.compute(modifier.getEffectiveLevel());
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.DRINK;
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        FluidStack fluid;
        FluidStack fluid2;
        boolean notActive;
        int useTime = useDuration - timeLeft;
        boolean bl = notActive = modifier != activeModifier;
        if (notActive && useTime == 0 && !(fluid2 = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty() && this.slurp(fluid2, modifier, entity, ModifierUtil.asPlayer((Entity)entity), IFluidHandler.FluidAction.SIMULATE) > 0) {
            tool.getPersistentData().putBoolean(modifier.getId(), true);
        }
        int duration = this.getUseDuration(tool, modifier);
        if (notActive && useTime == duration) {
            this.finishDrinking(tool, modifier, entity, true);
            tool.getPersistentData().remove(modifier.getId());
        } else if (!(useTime >= duration || useTime % 4 != 0 || notActive && !tool.getPersistentData().getBoolean(modifier.getId()) || (fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty())) {
            SlurpingModule.addFluidParticles(entity, fluid, 5);
            if (notActive) {
                entity.m_5496_(SoundEvents.f_11911_, 0.5f, entity.m_217043_().m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        if (useDuration - timeLeft == this.getUseDuration(tool, modifier)) {
            this.finishDrinking(tool, modifier, entity, modifier != activeModifier);
        }
        tool.getPersistentData().remove(modifier.getId());
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        if (keyModifier == TooltipKey.NORMAL && this.slurp(ToolTankHelper.TANK_HELPER.getFluid(tool), modifier, (LivingEntity)player, player, IFluidHandler.FluidAction.SIMULATE) > 0) {
            tool.getPersistentData().putInt(modifier.getId(), player.f_19797_ + this.duration.compute(modifier.getEffectiveLevel()));
            return true;
        }
        return false;
    }

    @Override
    public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
        tool.getPersistentData().remove(modifier.getId());
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView replacement = context.getReplacementTool();
        Level level = context.getLevel();
        if (!(level.f_46443_ || replacement != null && replacement.getItem() == tool.getItem() && replacement.getModifiers().equals(tool.getModifiers()))) {
            tool.getPersistentData().remove(modifier.getId());
        }
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData;
        int finishTime;
        if (isCorrectSlot && tool.hasTag(TinkerTags.Items.WORN_ARMOR) && (finishTime = (persistentData = tool.getPersistentData()).getInt(modifier.getId())) > 0) {
            int timeLeft = finishTime - holder.f_19797_;
            if (timeLeft < 0) {
                this.finishDrinking(tool, modifier, holder, true);
                persistentData.remove(modifier.getId());
            } else if (timeLeft % 4 == 0) {
                holder.m_5496_(SoundEvents.f_11911_, 0.5f, holder.m_217043_().m_188501_() * 0.1f + 0.9f);
                SlurpingModule.addFluidParticles(holder, ToolTankHelper.TANK_HELPER.getFluid(tool), 5);
            }
        }
    }
}

