/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public record ShearsModule(float flatBonus, float perLevelBonus, float expandedBonus, ModifierCondition<IToolStackView> condition) implements ModifierModule,
EntityInteractionModifierHook,
ToolActionModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ENTITY_INTERACT, ModifierHooks.TOOL_ACTION);
    public static final RecordLoadable<ShearsModule> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.defaultField("flat", (Object)Float.valueOf(0.0f), ShearsModule::flatBonus), (RecordField)FloatLoadable.FROM_ZERO.defaultField("per_level", (Object)Float.valueOf(0.0f), ShearsModule::perLevelBonus), (RecordField)FloatLoadable.FROM_ZERO.defaultField("expanded", (Object)Float.valueOf(0.0f), ShearsModule::expandedBonus), ModifierCondition.TOOL_FIELD, ShearsModule::new);

    public ShearsModule(float flatBonus, float perLevelBonus, float expandedBonus) {
        this(flatBonus, perLevelBonus, expandedBonus, ModifierCondition.ANY_TOOL);
    }

    public RecordLoadable<ShearsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && (toolAction == ToolActions.SHEARS_DIG || toolAction == ToolActions.SHEARS_HARVEST || toolAction == ToolActions.SHEARS_CARVE || toolAction == ToolActions.SHEARS_DISARM);
    }

    private static void runShearHook(IToolStackView tool, Player player, Entity entity, boolean isTarget) {
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.SHEAR_ENTITY).afterShearEntity(tool, entry, player, entity, isTarget);
        }
    }

    private static boolean shearEntity(ItemStack itemStack, IToolStackView tool, Level world, Player player, Entity entity, int fortune) {
        IForgeShearable target;
        Event.Result result = new TinkerToolEvent.ToolShearEvent(itemStack, tool, world, player, entity, fortune).fire();
        if (result != Event.Result.DEFAULT) {
            return result == Event.Result.ALLOW;
        }
        if (entity instanceof IForgeShearable && (target = (IForgeShearable)entity).isShearable(itemStack, world, entity.m_20183_())) {
            if (!world.f_46443_) {
                target.onSheared(player, itemStack, world, entity.m_20183_(), fortune).forEach(stack -> ModifierUtil.dropItem(entity, stack));
            }
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source) || !this.condition.matches(tool, modifier)) {
            return InteractionResult.PASS;
        }
        EquipmentSlot slotType = source.getSlot(hand);
        ItemStack stack = player.m_6844_(slotType);
        LootingContext context = new LootingContext((LivingEntity)player, target, null, Util.getSlotType(hand));
        int looting = LootingModifierHook.getLooting(tool, context, player.m_21120_(hand).getEnchantmentLevel(Enchantments.f_44982_));
        looting = ArmorLootingModifierHook.getLooting(tool, context, looting);
        Level world = player.m_20193_();
        if (ShearsModule.shearEntity(stack, tool, world, player, target, looting)) {
            float expanded;
            boolean broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType, modifier.getId());
            player.m_6674_(hand);
            player.m_36346_();
            ShearsModule.runShearHook(tool, player, target, true);
            if (!broken && (expanded = this.flatBonus + this.perLevelBonus * (modifier.getEffectiveLevel() - 1.0f) + this.expandedBonus * (float)tool.getVolatileData().getInt(IModifiable.EXPANDED)) > 0.0f) {
                for (LivingEntity aoeTarget : player.m_20193_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_((double)expanded, 0.25, (double)expanded))) {
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof ArmorStand && ((ArmorStand)aoeTarget).m_31677_() || !ShearsModule.shearEntity(stack, tool, world, player, (Entity)aoeTarget, looting)) continue;
                    broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType, modifier.getId());
                    ShearsModule.runShearHook(tool, player, (Entity)aoeTarget, false);
                    if (!broken) continue;
                    break;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

