/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.SimpleRecordLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ZoomModule implements ModifierModule,
GeneralInteractionModifierHook,
KeybindInteractModifierHook,
UsingToolModifierHook,
EquipmentChangeModifierHook
{
    SPYGLASS(new ModuleHook[]{ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.ARMOR_INTERACT}){

        @Override
        public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity living, int useDuration, int timeLeft, ModifierEntry activeModifier) {
            if (timeLeft == useDuration) {
                living.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
                if (living.m_9236_().f_46443_) {
                    ZoomModule.setZoom(modifier, living, 0.1f);
                }
            }
        }
    }
    ,
    SCOPE(new ModuleHook[]{ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING, ModifierHooks.EQUIPMENT_CHANGE}){

        @Override
        public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
            int useTime;
            if (entity.m_9236_().f_46443_ && (useTime = useDuration - timeLeft) > 0) {
                float drawTime = tool.getPersistentData().getInt(GeneralInteractionModifierHook.KEY_DRAWTIME);
                if (drawTime <= 0.0f) {
                    drawTime = 20.0f;
                }
                float fov = 1.0f - 0.6f * Math.min((float)useTime / drawTime, 1.0f);
                ZoomModule.setZoom(modifier, entity, fov);
            }
        }
    };

    public static final RecordLoadable<ZoomModule> LOADER;
    private final List<ModuleHook<?>> defaultHooks;

    @SafeVarargs
    private ZoomModule(ModuleHook<? super ZoomModule> ... hooks) {
        this.defaultHooks = List.of(hooks);
    }

    @Override
    public Integer getPriority() {
        return 10;
    }

    public RecordLoadable<ZoomModule> getLoader() {
        return LOADER;
    }

    private static void setZoom(ModifierEntry modifier, LivingEntity living, float amount) {
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(modifier.getId(), amount));
    }

    private static void stopZoom(ModifierEntry modifier, LazyOptional<TinkerDataCapability.Holder> tinkerData) {
        tinkerData.ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(modifier.getId()));
    }

    private static void stopZoom(ModifierEntry modifier, LivingEntity entity) {
        ZoomModule.stopZoom(modifier, (LazyOptional<TinkerDataCapability.Holder>)entity.getCapability(TinkerDataCapability.CAPABILITY));
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        player.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
        if (player.m_9236_().f_46443_) {
            ZoomModule.setZoom(modifier, (LivingEntity)player, 0.1f);
        }
        return true;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return ModifierUtil.blockWhileCharging(tool, UseAnim.SPYGLASS);
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 1200;
    }

    @Override
    public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
        player.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        if (player.m_9236_().f_46443_) {
            ZoomModule.stopZoom(modifier, (LivingEntity)player);
        }
    }

    @Override
    public void afterStopUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        entity.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        if (entity.m_9236_().f_46443_) {
            ZoomModule.stopZoom(modifier, entity);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView replacement;
        if (context.getEntity().m_9236_().f_46443_ && ((replacement = context.getReplacementTool()) == null || replacement.getModifierLevel(modifier.getModifier()) == 0)) {
            ZoomModule.stopZoom(modifier, context.getTinkerData());
        }
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return this.defaultHooks;
    }

    static {
        LOADER = new SimpleRecordLoadable((Loadable)new EnumLoadable(ZoomModule.class), "style", null, false);
    }
}

