/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.SingleItemContainer;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class AutosmeltModule
implements ModifierModule,
ProcessLootModifierHook {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROCESS_LOOT);
    public static final RecordLoadable<AutosmeltModule> LOADER = RecordLoadable.create((RecordField)Loadables.RECIPE_TYPE.flatXmap(type -> type, type -> type).list(-1).requiredField("recipe_types", m -> m.recipeTypes), (RecordField)FloatLoadable.PERCENT.requiredField("extra_drop_chance", m -> Float.valueOf(m.extraDropChance)), AutosmeltModule::new);
    private static final SingleItemContainer INVENTORY = new SingleItemContainer();
    private final List<RecipeType<? extends AbstractCookingRecipe>> recipeTypes;
    private final float extraDropChance;
    private final Cache<Item, Optional<? extends AbstractCookingRecipe>> recipeCache = CacheBuilder.newBuilder().maximumSize(64L).build();

    @SafeVarargs
    public AutosmeltModule(float extraDropChance, RecipeType<? extends AbstractCookingRecipe> ... types) {
        this(List.of(types), extraDropChance);
    }

    public RecordLoadable<AutosmeltModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Deprecated
    @ApiStatus.Internal
    public void clearCache() {
        this.recipeCache.invalidateAll();
    }

    private Optional<? extends AbstractCookingRecipe> findRecipe(ItemStack stack, Level world) {
        INVENTORY.setStack(stack);
        Optional recipe = Optional.empty();
        for (RecipeType<? extends AbstractCookingRecipe> recipeType : this.recipeTypes) {
            recipe = world.m_7465_().m_44015_(recipeType, (Container)INVENTORY, world);
            if (!recipe.isPresent()) continue;
            break;
        }
        INVENTORY.setStack(ItemStack.f_41583_);
        return recipe;
    }

    @Nullable
    private AbstractCookingRecipe findCachedRecipe(ItemStack stack, Level world) {
        if (stack.m_41782_()) {
            return this.findRecipe(stack, world).orElse(null);
        }
        try {
            return ((Optional)this.recipeCache.get((Object)stack.m_41720_(), () -> this.findRecipe(stack, world))).orElse(null);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private ItemStack smeltItem(ItemStack stack, Level world) {
        if (stack.m_204117_(TinkerTags.Items.AUTOSMELT_BLACKLIST)) {
            return stack;
        }
        AbstractCookingRecipe recipe = this.findCachedRecipe(stack, world);
        if (recipe != null) {
            INVENTORY.setStack(stack);
            ItemStack output = recipe.m_5874_((Container)INVENTORY, world.m_9598_());
            INVENTORY.setStack(ItemStack.f_41583_);
            if (stack.m_41613_() > 1) {
                output.m_41764_(output.m_41613_() * stack.m_41613_());
            }
            return output;
        }
        return stack;
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        ServerLevel world = context.m_78952_();
        if (!generatedLoot.isEmpty()) {
            ListIterator<ItemStack> iterator = generatedLoot.listIterator();
            while (iterator.hasNext()) {
                ItemStack smelted;
                ItemStack stack = iterator.next();
                if (stack == (smelted = this.smeltItem(stack, (Level)world))) continue;
                int level = modifier.intEffectiveLevel();
                if (level > 1 && this.extraDropChance > 0.0f && !smelted.m_204117_(TinkerTags.Items.AUTOSMELT_PLUS_BLACKLIST)) {
                    int extraItems = stack.m_41613_() * (level - 1);
                    int bonus = 0;
                    if (this.extraDropChance >= 1.0f) {
                        bonus = extraItems;
                    } else {
                        for (int i = 0; i < extraItems; ++i) {
                            if (!(context.m_230907_().m_188501_() < this.extraDropChance)) continue;
                            ++bonus;
                        }
                    }
                    smelted.m_41769_(bonus);
                }
                iterator.set(smelted);
            }
        }
    }

    public AutosmeltModule(List<RecipeType<? extends AbstractCookingRecipe>> recipeTypes, float extraDropChance) {
        this.recipeTypes = recipeTypes;
        this.extraDropChance = extraDropChance;
    }
}

