/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.tools.item.RepairKitItem;

public class FakeIngotItem
extends RepairKitItem {
    private final Object2BooleanArrayMap<MaterialId> missingItemCache = new Object2BooleanArrayMap();
    private final Predicate<MaterialId> missingItemGetter = material -> FakeIngotItem.hasItem(material, this.getRepairAmount());
    private final TagKey<IMaterial> validMaterials;

    public FakeIngotItem(Item.Properties properties, int value, TagKey<IMaterial> validMaterials) {
        super(properties, value);
        this.validMaterials = validMaterials;
        RecipeCacheInvalidator.addReloadListener(client -> this.missingItemCache.clear());
    }

    public static boolean hasItem(MaterialId material, float amount) {
        for (MaterialRecipe recipe : MaterialRecipeCache.getRecipes(material)) {
            if ((float)recipe.getValue() / (float)recipe.getNeeded() != amount) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().isInTag(material, this.validMaterials) && this.missingItemCache.computeIfAbsent((Object)material, this.missingItemGetter);
    }

    @Override
    public boolean canRepairInCraftingTable() {
        return false;
    }
}

