/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Orientation2D;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modules.armor.MinimapModule;
import slimeknights.tconstruct.tools.modules.armor.SleevesModule;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierClientEvents {
    private static final int SLOT_BACKGROUND_SIZE = 22;
    private static final int MAP_PADDING = 7;
    private static final int MAP_SIZE = 142;
    @Nonnull
    private static ItemStack nextOffhand = ItemStack.f_41583_;
    @Nonnull
    private static ItemStack currentSleeve = ItemStack.f_41583_;
    private static final List<ItemStack> itemFrames = new ArrayList<ItemStack>();

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() instanceof IModifiableDisplay) {
            event.getToolTip().removeIf(text -> {
                ComponentContents patt3730$temp = text.m_214077_();
                if (patt3730$temp instanceof TranslatableContents) {
                    TranslatableContents translatable = (TranslatableContents)patt3730$temp;
                    return translatable.m_237508_().equals("item.durability");
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    static void renderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        InteractionHand hand = event.getHand();
        ItemStack held = player.m_21120_(hand);
        ItemStack opposite = player.m_21120_(Util.getOpposite(hand));
        if (!held.m_41619_() && !opposite.m_41619_() && opposite.m_204117_(TinkerTags.Items.BALLISTAS) && ModifierUtil.getPersistentInt(opposite, ModifiableBowItem.KEY_BALLISTA, 0) == 1) {
            event.setCanceled(true);
            return;
        }
        if (hand == InteractionHand.OFF_HAND && held.m_41619_() && !player.m_20145_() && player.m_21205_().m_41720_() != Items.f_42573_ && ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SHOW_EMPTY_OFFHAND) > 0) {
            PoseStack matrices = event.getPoseStack();
            matrices.m_85836_();
            Minecraft.m_91087_().m_91290_().m_234586_().m_109346_(matrices, event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), player.m_5737_().m_20828_());
            matrices.m_85849_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void handleZoom(ComputeFovModifierEvent event) {
        event.getPlayer().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            FloatMultiplier constZoom;
            FloatMultiplier scaledZoom;
            float newFov = event.getNewFovModifier();
            float effectScale = ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue();
            if (effectScale > 0.0f && (scaledZoom = data.get(TinkerDataKeys.SCALED_FOV_MODIFIER)) != null) {
                if (effectScale == 1.0f) {
                    newFov *= scaledZoom.getValue();
                } else {
                    float original = event.getFovModifier();
                    newFov *= Mth.m_14179_((float)effectScale, (float)1.0f, (float)(scaledZoom.getValue() * original)) / original;
                }
            }
            if ((constZoom = data.get(TinkerDataKeys.FOV_MODIFIER)) != null) {
                newFov *= constZoom.getValue();
            }
            event.setNewFovModifier(newFov);
        });
    }

    @SubscribeEvent
    static void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        nextOffhand = ItemStack.f_41583_;
        itemFrames.clear();
    }

    @SubscribeEvent
    static void equipmentChange(ToolEquipmentChangeEvent event) {
        ModifierEntry entry;
        IToolStackView tool;
        if (event.getEntity() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        EquipmentChangeContext context = event.getContext();
        if (((Boolean)Config.CLIENT.renderShieldSlotItem.get()).booleanValue() && context.getChangedSlot() == EquipmentSlot.LEGS) {
            tool = context.getToolInSlot(EquipmentSlot.LEGS);
            if (tool != null && (entry = tool.getModifiers().getEntry(TinkerModifiers.shieldStrap.getId())) != ModifierEntry.EMPTY) {
                nextOffhand = entry.getHook(ToolInventoryCapability.HOOK).getStack(tool, entry, 0);
                return;
            }
            nextOffhand = ItemStack.f_41583_;
        }
        if (((Boolean)Config.CLIENT.renderSleevesItem.get()).booleanValue() && context.getChangedSlot() == EquipmentSlot.CHEST) {
            tool = context.getToolInSlot(EquipmentSlot.CHEST);
            if (tool != null && (entry = tool.getModifiers().getEntry(TinkerModifiers.sleeves.getId())) != ModifierEntry.EMPTY) {
                currentSleeve = entry.getHook(ToolInventoryCapability.HOOK).getStack(tool, entry, tool.getPersistentData().getInt(SleevesModule.SELECTED_SLOT));
                return;
            }
            currentSleeve = ItemStack.f_41583_;
        }
        if (((Boolean)Config.CLIENT.renderItemFrame.get()).booleanValue() && context.getChangedSlot() == EquipmentSlot.HEAD) {
            itemFrames.clear();
            tool = context.getToolInSlot(EquipmentSlot.HEAD);
            if (tool != null && (entry = tool.getModifier(TinkerModifiers.itemFrame.getId())).intEffectiveLevel() > 0) {
                entry.getHook(ToolInventoryCapability.HOOK).getAllStacks(tool, entry, itemFrames);
            }
        }
    }

    private static int getEffectOffset(Player player) {
        boolean hasBeneficial = false;
        for (MobEffectInstance instance : player.m_21220_()) {
            if (!instance.m_19575_() || !IClientMobEffectExtensions.of((MobEffectInstance)instance).isVisibleInGui(instance)) continue;
            if (instance.m_19544_().m_19486_()) {
                hasBeneficial = true;
                continue;
            }
            return 52;
        }
        return hasBeneficial ? 26 : 0;
    }

    @SubscribeEvent
    public static void renderHotbar(RenderGuiOverlayEvent.Post event) {
        TinkerDataCapability.Holder data;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null && mc.f_91080_.m_7043_() && event.getOverlay() != VanillaGuiOverlay.HOTBAR.type() || player == null || player != mc.m_91288_()) {
            return;
        }
        boolean renderShield = (Boolean)Config.CLIENT.renderShieldSlotItem.get() != false && !nextOffhand.m_41619_();
        boolean renderSleeves = (Boolean)Config.CLIENT.renderSleevesItem.get() != false && !currentSleeve.m_41619_();
        boolean renderItemFrame = (Boolean)Config.CLIENT.renderItemFrame.get() != false && !itemFrames.isEmpty();
        float mapScale = ((Double)Config.CLIENT.mapScale.get()).floatValue();
        ItemStack map = ItemStack.f_41583_;
        if (mapScale > 0.0f && (data = TinkerDataCapability.getData((LivingEntity)player)) != null) {
            map = data.get(MinimapModule.MAP, ItemStack.f_41583_);
        }
        if (!renderItemFrame && !renderShield && !renderSleeves && map.m_41619_()) {
            return;
        }
        MultiPlayerGameMode playerController = mc.f_91072_;
        if (playerController != null && playerController.m_105295_() != GameType.SPECTATOR) {
            int y;
            int x;
            boolean rightHanded;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            GuiGraphics graphics = event.getGuiGraphics();
            float partialTicks = event.getPartialTick();
            boolean emptyOffhand = player.m_21206_().m_41619_();
            boolean bl = rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
            if (renderShield) {
                x = scaledWidth / 2 + (rightHanded ? -117 : 101);
                y = scaledHeight - 38;
                graphics.m_280163_(Icons.ICONS, x - 3, y - 3, emptyOffhand ? 211.0f : 189.0f, 0.0f, 22, 22, 256, 256);
                mc.f_91065_.m_280585_(graphics, x, y, partialTicks, (Player)player, nextOffhand, 11);
            }
            if (renderSleeves) {
                x = scaledWidth / 2 + (rightHanded ? -136 : 120);
                y = scaledHeight - 19;
                graphics.m_280163_(Icons.ICONS, x - 3, y - 3, emptyOffhand ? 211.0f : (rightHanded ? 145.0f : 123.0f), 0.0f, 22, 22, 256, 256);
                mc.f_91065_.m_280585_(graphics, x, y, partialTicks, (Player)player, currentSleeve, 11);
            }
            Orientation2D mapLocation = null;
            int mapOffset = 0;
            if (!map.m_41619_() && mc.f_91073_ != null) {
                MapItemSavedData data2 = MapItem.m_42853_((ItemStack)map, (Level)mc.f_91073_);
                Integer index = MapItem.m_151131_((ItemStack)map);
                mapLocation = (Orientation2D)((Object)Config.CLIENT.mapLocation.get());
                Orientation2D.Orientation1D xOrientation = mapLocation.getX();
                Orientation2D.Orientation1D yOrientation = mapLocation.getY();
                mapOffset = (int)(142.0f * mapScale);
                int xStart = xOrientation.align(scaledWidth - mapOffset) + (Integer)Config.CLIENT.mapXOffset.get();
                int yStart = yOrientation.align(scaledHeight - mapOffset) + (Integer)Config.CLIENT.mapYOffset.get();
                if (mapLocation == Orientation2D.TOP_RIGHT) {
                    int effectOffset = ModifierClientEvents.getEffectOffset((Player)player);
                    yStart += effectOffset;
                    mapOffset += effectOffset;
                }
                PoseStack poseStack = graphics.m_280168_();
                poseStack.m_85836_();
                float padding = 7.0f * mapScale;
                poseStack.m_252880_((float)xStart + padding, (float)yStart + padding, 0.0f);
                poseStack.m_85841_(mapScale, mapScale, -1.0f);
                int light = 0xF000F0;
                MultiBufferSource.BufferSource buffer = graphics.m_280091_();
                VertexConsumer consumer = buffer.m_6299_(data2 == null ? ItemInHandRenderer.f_109297_ : ItemInHandRenderer.f_109298_);
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                consumer.m_252986_(matrix, -7.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
                consumer.m_252986_(matrix, 135.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
                consumer.m_252986_(matrix, 135.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
                consumer.m_252986_(matrix, -7.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
                if (data2 != null && index != null) {
                    Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, (MultiBufferSource)buffer, index.intValue(), data2, false, light);
                }
                poseStack.m_85849_();
            }
            if (renderItemFrame) {
                int columns = (Integer)Config.CLIENT.itemsPerRow.get();
                int count = itemFrames.size();
                int rows = count / columns;
                int inLastRow = count % columns;
                if (inLastRow == 0) {
                    inLastRow = columns;
                } else {
                    ++rows;
                }
                Orientation2D location = (Orientation2D)((Object)Config.CLIENT.itemFrameLocation.get());
                Orientation2D.Orientation1D xOrientation = location.getX();
                Orientation2D.Orientation1D yOrientation = location.getY();
                int xStart = xOrientation.align(scaledWidth - 22 * columns) + (Integer)Config.CLIENT.itemFrameXOffset.get();
                int yStart = yOrientation.align(scaledHeight - 22 * rows) + (Integer)Config.CLIENT.itemFrameYOffset.get();
                if (location == mapLocation) {
                    switch (yOrientation) {
                        case START: {
                            yStart += mapOffset;
                            break;
                        }
                        case MIDDLE: {
                            yStart += (mapOffset + 22 * rows) / 2;
                            break;
                        }
                        case END: {
                            yStart -= mapOffset;
                        }
                    }
                } else if (location == Orientation2D.TOP_RIGHT) {
                    yStart += ModifierClientEvents.getEffectOffset((Player)player);
                }
                int lastRow = rows - 1;
                for (int r = 0; r < lastRow; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        graphics.m_280163_(Icons.ICONS, xStart + c * 22, yStart + r * 22, 167.0f, 0.0f, 22, 22, 256, 256);
                    }
                }
                int lastRowOffset = xOrientation.align((columns - inLastRow) * 2) * 22 / 2;
                for (int c = 0; c < inLastRow; ++c) {
                    graphics.m_280163_(Icons.ICONS, xStart + c * 22 + lastRowOffset, yStart + lastRow * 22, 167.0f, 0.0f, 22, 22, 256, 256);
                }
                int i = 0;
                xStart += 3;
                yStart += 3;
                for (int r = 0; r < lastRow; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        mc.f_91065_.m_280585_(graphics, xStart + c * 22, yStart + r * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                        ++i;
                    }
                }
                for (int c = 0; c < inLastRow; ++c) {
                    mc.f_91065_.m_280585_(graphics, xStart + c * 22 + lastRowOffset, yStart + lastRow * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                    ++i;
                }
            }
            RenderSystem.disableBlend();
        }
    }
}

