/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.MaterialSwappingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
extends MaterialSwappingRecipe {
    public static final RecordLoadable<TinkerStationPartSwapping> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)TOOLS_FIELD, (RecordField)STACK_SIZE_FIELD, TinkerStationPartSwapping::new);

    public TinkerStationPartSwapping(ResourceLocation id, Ingredient tools, int maxStackSize) {
        super(id, tools, maxStackSize);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        Item item;
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !this.tools.test(tinkerable) || !((item = tinkerable.m_41720_()) instanceof IModifiable)) {
            return false;
        }
        IModifiable modifiable = (IModifiable)item;
        List<IToolPart> parts = ToolPartsHook.parts(modifiable.getToolDefinition());
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (foundItem) {
                return false;
            }
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof IToolPart) || parts.stream().noneMatch(p -> p == item2)) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        List<IToolPart> parts = ToolPartsHook.parts(inv.getTinkerable().getDefinition());
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof IToolPart)) {
                return RecipeResult.pass();
            }
            IToolPart part = (IToolPart)item;
            MaterialVariantId partVariant = part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return RecipeResult.pass();
            }
            int index = i;
            if ((i >= parts.size() || parts.get(i) != item) && (index = IntStream.range(0, parts.size()).filter(pi -> parts.get(pi) == item).findFirst().orElse(-1)) == -1) {
                return RecipeResult.pass();
            }
            return this.swapMaterial(inv, partVariant, index, MaterialCastingLookup.getItemCost(part));
        }
        return RecipeResult.pass();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }
}

