/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

@ApiStatus.Internal
public enum SmelteryCompat {
    TIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTin, CompatType.ORE),
    ALUMINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenAluminum, CompatType.ORE, MaterialIds.aluminum),
    LEAD((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLead, CompatType.ORE, MaterialIds.lead),
    SILVER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSilver, CompatType.ORE, MaterialIds.silver),
    NICKEL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNickel, CompatType.ORE),
    ZINC((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenZinc, CompatType.ORE),
    PLATINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPlatinum, CompatType.ORE),
    TUNGSTEN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTungsten, CompatType.ORE),
    OSMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenOsmium, CompatType.ORE, MaterialIds.osmium),
    URANIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenUranium, CompatType.ORE, MaterialIds.necronium),
    CHROMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenChromium, CompatType.ORE),
    CADMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenCadmium, CompatType.ORE),
    BRONZE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBronze, CompatType.ALLOY, MaterialIds.bronze),
    BRASS((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBrass, CompatType.ALLOY, MaterialIds.platedSlimewood),
    ELECTRUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenElectrum, CompatType.ALLOY, MaterialIds.electrum),
    INVAR((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenInvar, CompatType.ALLOY, MaterialIds.invar),
    CONSTANTAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenConstantan, CompatType.ALLOY, MaterialIds.constantan),
    PEWTER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPewter, CompatType.ALLOY, MaterialIds.pewter),
    ENDERIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenEnderium, CompatType.ALLOY),
    LUMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLumium, CompatType.ALLOY),
    SIGNALUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSignalum, CompatType.ALLOY),
    REFINED_GLOWSTONE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedGlowstone, CompatType.ALLOY),
    REFINED_OBSIDIAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedObsidian, CompatType.ALLOY),
    NICROSIL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNicrosil, CompatType.ALLOY, MaterialIds.nicrosil),
    DURALUMIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenDuralumin, CompatType.ALLOY),
    BENDALLOY((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBendalloy, CompatType.ALLOY),
    STEELEAF((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSteeleaf, CompatType.NONE, MaterialIds.steeleaf),
    FIERY((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.fieryLiquid, CompatType.ALLOY, MaterialIds.fiery);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final CompatType type;
    @Deprecated(forRemoval=true)
    private final String[] tags = new String[0];
    @Nullable
    private final MaterialId material;

    private SmelteryCompat(@Nullable FluidObject<? extends ForgeFlowingFluid> fluid, CompatType type, MaterialId material) {
        this.fluid = fluid;
        this.type = type;
        this.material = material;
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, CompatType type) {
        this(fluid, type, null);
    }

    @Deprecated(forRemoval=true)
    public boolean isOre() {
        return this.type == CompatType.ORE;
    }

    @Deprecated(forRemoval=true)
    public String getAltTag() {
        return "";
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public boolean isPresent() {
        if (this.material != null && MaterialRegistry.getMaterial(this.material) != IMaterial.UNKNOWN) {
            return true;
        }
        return SmelteryCompat.ingotPresent(this.name);
    }

    private static boolean ingotPresent(String name) {
        Optional tag = BuiltInRegistries.f_257033_.m_203431_(ItemTags.create((ResourceLocation)Mantle.commonResource((String)("ingots/" + name))));
        return tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0;
    }

    public String getName() {
        return this.name;
    }

    public CompatType getType() {
        return this.type;
    }

    @Deprecated
    public String[] getTags() {
        return this.tags;
    }

    public static enum CompatType {
        ORE,
        ALLOY,
        NONE;

    }
}

