/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;

public enum Byproduct implements IByproduct
{
    COPPER(true, (FluidObject<?>)TinkerFluids.moltenCopper),
    IRON(true, (FluidObject<?>)TinkerFluids.moltenIron),
    GOLD(true, (FluidObject<?>)TinkerFluids.moltenGold),
    SMALL_GOLD("gold", true, (FluidObject<?>)TinkerFluids.moltenGold, 30, 10, IMeltingContainer.OreRateType.METAL),
    TINY_GOLD("gold", true, (FluidObject<?>)TinkerFluids.moltenGold, 10, 10, IMeltingContainer.OreRateType.NONE),
    COBALT(true, (FluidObject<?>)TinkerFluids.moltenCobalt),
    STEEL(true, (FluidObject<?>)TinkerFluids.moltenSteel),
    DEBRIS("netherite_scrap", true, (FluidObject<?>)TinkerFluids.moltenDebris, 90, 10, IMeltingContainer.OreRateType.METAL),
    ALUMINUM(false, (FluidObject<?>)TinkerFluids.moltenAluminum),
    TIN(false, (FluidObject<?>)TinkerFluids.moltenTin),
    SILVER(false, (FluidObject<?>)TinkerFluids.moltenSilver),
    NICKEL(false, (FluidObject<?>)TinkerFluids.moltenNickel),
    LEAD(false, (FluidObject<?>)TinkerFluids.moltenLead),
    PLATINUM(false, (FluidObject<?>)TinkerFluids.moltenPlatinum),
    ZINC(false, (FluidObject<?>)TinkerFluids.moltenZinc),
    CHROMIUM(false, (FluidObject<?>)TinkerFluids.moltenChromium),
    CADMIUM(false, (FluidObject<?>)TinkerFluids.moltenCadmium),
    DIAMOND(true, (FluidObject<?>)TinkerFluids.moltenDiamond, 100, 25, IMeltingContainer.OreRateType.GEM),
    SMALL_DIAMOND("diamond", true, (FluidObject<?>)TinkerFluids.moltenDiamond, 25, 25, IMeltingContainer.OreRateType.GEM);

    private final String name;
    private final boolean alwaysPresent;
    private final FluidObject<?> fluid;
    private final int amount;
    private final int damageUnit;
    private final IMeltingContainer.OreRateType oreRate;

    private Byproduct(boolean alwaysPresent, FluidObject<?> fluid, int amount, int damageUnit, IMeltingContainer.OreRateType oreRate) {
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = amount;
        this.damageUnit = damageUnit;
        this.oreRate = oreRate;
    }

    private Byproduct(boolean alwaysPresent, FluidObject<?> fluid) {
        this(alwaysPresent, fluid, 90, 10, IMeltingContainer.OreRateType.METAL);
    }

    @Override
    public FluidOutput getFluid(float scale) {
        return this.fluid.result((int)((float)this.amount * scale));
    }

    private Byproduct(String name, boolean alwaysPresent, FluidObject<?> fluid, int amount, int damageUnit, IMeltingContainer.OreRateType oreRate) {
        this.name = name;
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = amount;
        this.damageUnit = damageUnit;
        this.oreRate = oreRate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAlwaysPresent() {
        return this.alwaysPresent;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public int getDamageUnit() {
        return this.damageUnit;
    }

    @Override
    public IMeltingContainer.OreRateType getOreRate() {
        return this.oreRate;
    }
}

