/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.inventory.SingleItemHandler;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.EmptyFluidHandlerItem;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;

public class ProxyItemTank<T extends MantleBlockEntity>
extends SingleItemHandler<T>
implements IFluidHandler {
    private IFluidHandlerItem itemTank;

    public ProxyItemTank(T parent) {
        super(parent, 1);
    }

    protected boolean isItemValid(ItemStack stack) {
        Item craftRemainingItem = stack.m_41720_().m_41469_();
        return !stack.m_204117_(TinkerTags.Items.PROXY_TANK_BLACKLIST) && (craftRemainingItem == null || !RegistryHelper.contains(TinkerTags.Items.PROXY_TANK_BLACKLIST, (Item)craftRemainingItem)) && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    private void setStack(ItemStack newStack, boolean syncSame) {
        boolean needsUpdate;
        if (newStack.m_41619_()) {
            newStack = ItemStack.f_41583_;
        }
        ItemStack oldStack = this.getStack();
        super.setStack(newStack);
        Level world = this.parent.m_58904_();
        boolean bl = needsUpdate = world != null && !world.f_46443_;
        if (oldStack != newStack) {
            this.itemTank = null;
            if (needsUpdate) {
                needsUpdate = oldStack.m_41619_() && newStack.m_41619_() || !ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)newStack);
            }
        } else if (needsUpdate) {
            needsUpdate = syncSame;
        }
        if (needsUpdate) {
            ((IFluidTankUpdater)this.parent).onTankContentsChanged();
            BlockPos pos = this.parent.m_58899_();
            TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, 0, pos), (LevelAccessor)world, pos);
        }
    }

    public void setStack(ItemStack newStack) {
        this.setStack(newStack, false);
    }

    private IFluidHandlerItem getItemTank() {
        if (this.itemTank == null) {
            ItemStack stack = this.getStack();
            this.itemTank = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseGet(() -> new EmptyFluidHandlerItem(stack));
        }
        return this.itemTank;
    }

    public int getTanks() {
        return this.getItemTank().getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getItemTank().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getItemTank().getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getItemTank().isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandlerItem tank = this.getItemTank();
        int filled = tank.fill(resource, action);
        if (filled > 0 && action.execute()) {
            this.setStack(tank.getContainer(), true);
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandlerItem tank = this.getItemTank();
        FluidStack drained = tank.drain(resource, action);
        if (!drained.isEmpty() && action.execute()) {
            this.setStack(tank.getContainer(), true);
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        IFluidHandlerItem tank = this.getItemTank();
        FluidStack drained = tank.drain(maxDrain, action);
        if (!drained.isEmpty() && action.execute()) {
            this.setStack(tank.getContainer(), true);
        }
        return drained;
    }
}

