/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankBlockEntity
extends SmelteryComponentBlockEntity
implements ITankBlockEntity {
    public static final int DEFAULT_CAPACITY = 4000;
    protected final FluidTankAnimated tank;
    private final LazyOptional<IFluidHandler> holder;
    private int lastStrength;

    public static int getCapacity(Block block) {
        if (block instanceof ITankBlock) {
            return ((ITankBlock)block).getCapacity();
        }
        return 4000;
    }

    public static int getCapacity(Item item) {
        if (item instanceof BlockItem) {
            return TankBlockEntity.getCapacity(((BlockItem)item).m_40614_());
        }
        return 4000;
    }

    public TankBlockEntity(BlockPos pos, BlockState state) {
        ITankBlock tank;
        Block block = state.m_60734_();
        this(pos, state, block instanceof ITankBlock ? (tank = (ITankBlock)block) : (ITankBlock)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK));
    }

    public TankBlockEntity(BlockPos pos, BlockState state, ITankBlock block) {
        this((BlockEntityType)TinkerSmeltery.tank.get(), pos, state, block);
    }

    protected TankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ITankBlock block) {
        super(type, pos, state);
        this.lastStrength = -1;
        this.tank = new FluidTankAnimated(block.getCapacity(), this);
        this.holder = LazyOptional.of(() -> this.tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.FLUID_STACK, (Object)this.tank.getFluid()).with(ModelProperties.TANK_CAPACITY, (Object)this.tank.getCapacity()).build();
    }

    public static void updateLight(BlockEntity be, IFluidTank tank) {
        BlockState state;
        FluidStack fluid;
        int light;
        Level level = be.m_58904_();
        if (level != null && !level.f_46443_ && (light = (fluid = tank.getFluid()).isEmpty() ? 0 : fluid.getFluid().getFluidType().getLightLevel(fluid)) != (Integer)(state = be.m_58900_()).m_61143_((Property)SearedTankBlock.LIGHT)) {
            level.m_7731_(be.m_58899_(), (BlockState)state.m_61124_((Property)SearedTankBlock.LIGHT, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    @Override
    public void onTankContentsChanged() {
        ITankBlockEntity.super.onTankContentsChanged();
        if (this.f_58857_ != null) {
            TankBlockEntity.updateLight((BlockEntity)this, (IFluidTank)this.tank);
            this.requestModelDataUpdate();
        }
    }

    public void onLoad() {
        BlockEntity blockEntity;
        BlockPos masterPos;
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (masterPos = this.getMasterPos()) != null && (blockEntity = this.f_58857_.m_7702_(masterPos)) instanceof IMasterLogic) {
            IMasterLogic master = (IMasterLogic)blockEntity;
            master.onServantLoad(this);
        }
    }

    public void setTankTag(ItemStack stack) {
        TankItem.setTank(stack, this.tank);
    }

    public void updateTank(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
            TankBlockEntity.updateLight((BlockEntity)this, (IFluidTank)this.tank);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.setCapacity(TankBlockEntity.getCapacity(this.m_58900_().m_60734_()));
        this.updateTank(tag.m_128469_("tank"));
        super.m_142466_(tag);
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        if (!this.tank.isEmpty()) {
            tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public static interface ITankBlock {
        public int getCapacity();
    }
}

