/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.common.Sounds;

public class TeleportHelper {
    private static final Set<RelativeMovement> PACKET_FLAGS = EnumSet.of(RelativeMovement.X, RelativeMovement.Y, RelativeMovement.Z, RelativeMovement.X_ROT, RelativeMovement.Y_ROT);

    @CanIgnoreReturnValue
    public static boolean randomNearbyTeleport(LivingEntity living, ITeleportEventFactory factory) {
        return TeleportHelper.randomNearbyTeleport(living, factory, 16, 16);
    }

    @CanIgnoreReturnValue
    public static boolean randomNearbyTeleport(LivingEntity living, ITeleportEventFactory factory, int diameter, int chances) {
        int n;
        Level level = living.m_9236_();
        if (level.f_46443_) {
            return true;
        }
        double posX = living.m_20185_();
        double posY = living.m_20186_();
        double posZ = living.m_20189_();
        RandomSource random = living.m_217043_();
        float minHeight = level.m_141937_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            n = level.m_141937_() + server.m_143344_();
        } else {
            n = level.m_151558_();
        }
        float maxHeight = n - 1;
        for (int i = 0; i < chances; ++i) {
            double x = posX + (random.m_188500_() - 0.5) * (double)diameter;
            double y = Mth.m_14008_((double)(posY + (double)(random.m_188503_(diameter) - 8)), (double)minHeight, (double)maxHeight);
            double z = posZ + (random.m_188500_() - 0.5) * (double)diameter;
            if (living.m_20159_()) {
                living.m_8127_();
            }
            level.m_214171_(GameEvent.f_238175_, living.m_20182_(), GameEvent.Context.m_223717_((Entity)living));
            EntityTeleportEvent event = factory.create(living, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled() || !living.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            SoundEvent soundevent = Sounds.SLIME_TELEPORT.getSound();
            level.m_6263_(null, posX, posY, posZ, soundevent, living.m_5720_(), 1.0f, 1.0f);
            living.m_5496_(soundevent, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private static void spawnParticles(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (int i = 0; i < 32; ++i) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + level.f_46441_.m_188500_() * 2.0, entity.m_20189_(), 1, level.f_46441_.m_188583_(), 0.0, level.f_46441_.m_188583_(), 0.0);
            }
        }
    }

    public static boolean tryTeleport(EntityTeleportEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            Entity entity = event.getEntity();
            TeleportHelper.spawnParticles(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)entity;
                playerMP.f_8906_.m_9780_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), playerMP.m_146908_(), playerMP.m_146909_(), PACKET_FLAGS);
            } else {
                entity.m_6034_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            }
            TeleportHelper.spawnParticles(entity);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.ENDERPORTING.getSound(), entity.m_5720_(), 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ITeleportEventFactory {
        public EntityTeleportEvent create(LivingEntity var1, double var2, double var4, double var6);
    }
}

