/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class MaterialBlockEntity
extends MantleBlockEntity {
    @Nonnull
    private MaterialVariantId material = IMaterial.UNKNOWN_ID;

    public MaterialBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public MaterialBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerToolParts.materialBlock.get(), pos, state);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.MATERIAL, (Object)this.material).build();
    }

    public void setMaterial(MaterialVariantId material) {
        MaterialVariantId oldMaterial = this.material;
        this.material = material;
        if (!oldMaterial.equals(material)) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.material != IMaterial.UNKNOWN_ID) {
            tags.m_128359_("Material", this.material.toString());
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_("Material", 8)) {
            this.material = Objects.requireNonNullElse(MaterialVariantId.tryParse(tags.m_128461_("Material")), IMaterial.UNKNOWN_ID);
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }

    @Nonnull
    public MaterialVariantId getMaterial() {
        return this.material;
    }
}

