/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.armor.DummyArmorMaterial;

public class ModifiableArmorMaterial
extends DummyArmorMaterial {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private final ToolDefinition[] armorDefinitions;

    private ModifiableArmorMaterial(ResourceLocation id, SoundEvent equipSound, ToolDefinition ... armorDefinitions) {
        super(id, equipSound);
        if (armorDefinitions.length != 4) {
            throw new IllegalArgumentException("Must have an armor definition for each slot");
        }
        this.armorDefinitions = armorDefinitions;
    }

    public static ModifiableArmorMaterial create(ResourceLocation id, SoundEvent equipSound, ArmorItem.Type ... slots) {
        ToolDefinition[] definitions = new ToolDefinition[4];
        for (ArmorItem.Type slot : slots) {
            definitions[slot.ordinal()] = ToolDefinition.create(id.m_266382_("_" + slot.m_266355_()));
        }
        return new ModifiableArmorMaterial(id, equipSound, definitions);
    }

    public static ModifiableArmorMaterial create(ResourceLocation id, SoundEvent equipSound) {
        return ModifiableArmorMaterial.create(id, equipSound, ArmorItem.Type.values());
    }

    @Nullable
    public ToolDefinition getArmorDefinition(ArmorItem.Type slotType) {
        return this.armorDefinitions[slotType.ordinal()];
    }
}

