/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentIterator;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class EquipmentContext {
    private final LivingEntity entity;
    protected final boolean[] fetchedTool = new boolean[6];
    protected final IToolStackView[] toolsInSlots = new IToolStackView[6];
    private LazyOptional<TinkerDataCapability.Holder> tinkerData = null;
    private Iterable<EquipmentIterator.EquipmentEntry> toolIterable;
    private Iterable<EquipmentIterator.EquipmentEntry> armorIterable;
    private Iterable<EquipmentIterator.EquipmentEntry> wornArmorIterable;

    public static EquipmentContext withTool(LivingEntity living, IToolStackView tool, EquipmentSlot slot) {
        EquipmentContext context = new EquipmentContext(living);
        int index = slot.m_20750_();
        context.toolsInSlots[index] = tool;
        context.fetchedTool[index] = true;
        return context;
    }

    @Nullable
    protected static IToolStackView getToolStackIfModifiable(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return ToolStack.from(stack);
        }
        return null;
    }

    public Level getLevel() {
        return this.entity.m_9236_();
    }

    @Nullable
    public IToolStackView getToolInSlot(EquipmentSlot slotType) {
        int index = slotType.m_20750_();
        if (!this.fetchedTool[index]) {
            this.toolsInSlots[index] = EquipmentContext.getToolStackIfModifiable(this.entity.m_6844_(slotType));
            this.fetchedTool[index] = true;
        }
        return this.toolsInSlots[index];
    }

    @Nullable
    public IToolStackView getValidTool(EquipmentSlot slotType) {
        return ModifierUtil.validArmorSlot(this.entity, slotType) ? this.getToolInSlot(slotType) : null;
    }

    public boolean hasModifiableArmor(EquipmentSlot ... slots) {
        for (EquipmentSlot slotType : slots) {
            if (this.getValidTool(slotType) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasModifiableArmor() {
        return this.hasModifiableArmor(EquipmentSlot.values());
    }

    public LazyOptional<TinkerDataCapability.Holder> getTinkerData() {
        if (this.tinkerData == null) {
            this.tinkerData = this.entity.getCapability(TinkerDataCapability.CAPABILITY);
        }
        return this.tinkerData;
    }

    public Iterable<EquipmentIterator.EquipmentEntry> makeIterable(Function<EquipmentSlot, IToolStackView> getter) {
        ArrayList<IToolStackView> tools = new ArrayList<IToolStackView>(6);
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(6);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            IToolStackView tool = getter.apply(slot);
            if (tool == null || tool.isBroken() || tool.getModifiers().isEmpty()) continue;
            tools.add(tool);
            slots.add(slot);
        }
        return EquipmentIterator.iterable(tools, slots);
    }

    public Iterable<EquipmentIterator.EquipmentEntry> iterateTools() {
        if (this.toolIterable == null) {
            this.toolIterable = this.makeIterable(this::getValidTool);
        }
        return this.toolIterable;
    }

    public Iterable<EquipmentIterator.EquipmentEntry> iterateArmor() {
        if (this.armorIterable == null) {
            this.armorIterable = this.makeIterable(slot -> this.entity.m_6844_(slot).m_204117_(TinkerTags.Items.ARMOR) ? this.getValidTool((EquipmentSlot)slot) : null);
        }
        return this.armorIterable;
    }

    public Iterable<EquipmentIterator.EquipmentEntry> iterateWornArmor() {
        if (this.wornArmorIterable == null) {
            this.wornArmorIterable = this.makeIterable(slot -> slot.m_254934_() ? this.getToolInSlot((EquipmentSlot)slot) : null);
        }
        return this.wornArmorIterable;
    }

    public EquipmentContext(LivingEntity entity) {
        this.entity = entity;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }
}

