/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.capability.BlockItemProviderCapability;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface ToolBlockItemProviderHook {
    public ItemStack getBlockItemStack(IToolStackView var1, ModifierEntry var2, @Nullable LivingEntity var3);

    public boolean consumeBlockItem(IToolStackView var1, ModifierEntry var2, ItemStack var3, @Nullable LivingEntity var4);

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<BlockItemProviderCapability> lazy = LazyOptional.of(() -> new CapabilityImpl((IToolStackView)tool.get()));

        public Provider(Supplier<? extends IToolStackView> tool) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            return BlockItemProviderCapability.CAPABILITY.orEmpty(cap, this.lazy);
        }
    }

    public record CapabilityImpl(IToolStackView tool) implements BlockItemProviderCapability
    {
        @Override
        public ItemStack getBlockItemStack(ItemStack capStack, @Nullable LivingEntity entity) {
            for (ModifierEntry entry : this.tool.getModifiers()) {
                ToolBlockItemProviderHook hook = entry.getHook(ModifierHooks.BLOCK_ITEM_PROVIDER);
                ItemStack stack = hook.getBlockItemStack(this.tool, entry, entity);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof BlockItem) {
                    return stack;
                }
                TConstruct.LOG.warn("ToolBlockItemProviderHook implementation tried to return a non-empty, non-blockitem stack! Hook: {}, Hook Class: {}, Provided Item: {}", (Object)hook, (Object)hook.getClass().getName(), (Object)BuiltInRegistries.f_257033_.m_7447_((Object)item));
            }
            return ItemStack.f_41583_;
        }

        @Override
        public void consume(ItemStack capStack, ItemStack backingStack, @Nullable LivingEntity entity) {
            for (ModifierEntry entry : this.tool.getModifiers()) {
                if (!entry.getHook(ModifierHooks.BLOCK_ITEM_PROVIDER).consumeBlockItem(this.tool, entry, backingStack, entity)) continue;
                return;
            }
            TConstruct.LOG.warn("Could not find a modifier to consume {} from after providing it from ToolBlockItemProviderHook. This is likely causing a duplication glitch! Stack nbt: {}", (Object)BuiltInRegistries.f_257033_.m_7981_((Object)backingStack.m_41720_()), (Object)backingStack.m_41783_());
        }
    }
}

