/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;

public interface BlockItemProviderCapability {
    public static final ResourceLocation ID = TConstruct.getResource("block_provider");
    public static final Capability<BlockItemProviderCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BlockItemProviderCapability>(){});

    @ApiStatus.Internal
    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, BlockItemProviderCapability::register);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, EventPriority.LOW, BlockItemProviderCapability::attachCapability);
    }

    private static void register(RegisterCapabilitiesEvent event) {
        event.register(BlockItemProviderCapability.class);
    }

    private static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() instanceof BlockItem) {
            event.addCapability(SimpleBlockItem.ID, (ICapabilityProvider)SimpleBlockItem.INSTANCE);
        }
    }

    @Nullable
    public static BlockItemProviderCapability getBlockProvider(ItemStack stack) {
        return (BlockItemProviderCapability)LogicHelper.orElseNull((LazyOptional)stack.getCapability(CAPABILITY));
    }

    @Nullable
    public static BlockItem verifyBlockItem(ItemStack stack, BlockItemProviderCapability blockProvider) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bItem = (BlockItem)item;
            return bItem;
        }
        TConstruct.LOG.warn("BlockItemProviderCapability implementation tried to return a non-empty, non-blockitem stack! Cap: {}, Cap Class: {}, Provided Item: {}", (Object)blockProvider, (Object)blockProvider.getClass().getName(), (Object)BuiltInRegistries.f_257033_.m_7447_((Object)stack.m_41720_()));
        return null;
    }

    public ItemStack getBlockItemStack(ItemStack var1, @Nullable LivingEntity var2);

    public void consume(ItemStack var1, ItemStack var2, @Nullable LivingEntity var3);

    public static final class SimpleBlockItem
    implements BlockItemProviderCapability,
    ICapabilityProvider {
        public static final SimpleBlockItem INSTANCE = new SimpleBlockItem();
        private static final ResourceLocation ID = TConstruct.getResource("block_item_provider");
        private final LazyOptional<BlockItemProviderCapability> lazy = LazyOptional.of(() -> this);

        @Override
        public ItemStack getBlockItemStack(ItemStack capStack, @Nullable LivingEntity entity) {
            return capStack.m_41619_() ? ItemStack.f_41583_ : capStack;
        }

        @Override
        public void consume(ItemStack capStack, ItemStack backingStack, @Nullable LivingEntity entity) {
            capStack.m_41774_(1);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction dir) {
            return CAPABILITY.orEmpty(cap, this.lazy);
        }
    }
}

