/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.IntArrayLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.MaterialSwappingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartSwappingOverrideRecipe
extends MaterialSwappingRecipe {
    public static final RecordLoadable<PartSwappingOverrideRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)TOOLS_FIELD, (RecordField)STACK_SIZE_FIELD, (RecordField)TinkerLoadables.TOOL_PART_ITEM.requiredField("part", r -> r.part), (RecordField)new IntArrayLoadable((Loadable)IntLoadable.FROM_ZERO, -1, 10).requiredField("index", r -> r.indices), PartSwappingOverrideRecipe::new);
    private final IToolPart part;
    private final int[] indices;

    protected PartSwappingOverrideRecipe(ResourceLocation id, Ingredient tools, int maxStackSize, IToolPart part, int[] indices) {
        super(id, tools, maxStackSize);
        this.part = part;
        this.indices = indices;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !this.tools.test(tinkerable)) {
            return false;
        }
        List<MaterialStatsId> materials = ToolMaterialHook.stats(IModifiable.getToolDefinition(tinkerable.m_41720_()));
        if (this.indices[0] >= materials.size()) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_41619_()) continue;
            if (found || input.m_41720_() != this.part) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        List<MaterialStatsId> materials = ToolMaterialHook.stats(inv.getTinkerable().getDefinition());
        if (materials.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            MaterialVariantId partVariant = this.part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return RecipeResult.pass();
            }
            int index = this.indices[0];
            if (i < materials.size()) {
                for (int j = 1; j < this.indices.length; ++j) {
                    if (this.indices[j] != i) continue;
                    index = i;
                    break;
                }
            }
            if (MaterialRegistry.getInstance().getMaterialStats(partVariant.getId(), materials.get(index)).isEmpty()) {
                return INVALID_MATERIAL;
            }
            return this.swapMaterial(inv, partVariant, index, MaterialCastingLookup.getItemCost(this.part));
        }
        return RecipeResult.pass();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.fixedMaterialSwapping.get();
    }
}

