/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.BitSet;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.FixedMaterialSwappingRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.PartSwappingOverrideRecipe;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class MaterialSwappingRecipeBuilder
extends AbstractRecipeBuilder<MaterialSwappingRecipeBuilder> {
    private final Ingredient tools;
    private int maxStackSize = 16;
    private final BitSet indices = new BitSet();
    private IToolPart part = null;
    private SizedIngredient ingredient = SizedIngredient.EMPTY;
    private MaterialVariantId material = IMaterial.UNKNOWN_ID;
    private int repairValue = 0;

    public static MaterialSwappingRecipeBuilder tool(ItemLike tool) {
        return MaterialSwappingRecipeBuilder.tools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{tool}));
    }

    public static MaterialSwappingRecipeBuilder tools(TagKey<Item> tag) {
        return MaterialSwappingRecipeBuilder.tools(Ingredient.m_204132_(tag));
    }

    public MaterialSwappingRecipeBuilder index(int index) {
        this.indices.set(index);
        return this;
    }

    public MaterialSwappingRecipeBuilder material(MaterialVariantId material, SizedIngredient ingredient) {
        this.material = material;
        this.ingredient = ingredient;
        return this;
    }

    public MaterialSwappingRecipeBuilder material(MaterialVariantId material, ItemLike item) {
        return this.material(material, SizedIngredient.fromItems((ItemLike[])new ItemLike[]{item}));
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Loadables.ITEM.getKey((Object)this.tools.m_43908_()[0].m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        int[] indices = this.indices.stream().toArray();
        if (indices.length == 0) {
            throw new IllegalStateException("Must set index");
        }
        if (this.part != null) {
            if (this.ingredient != SizedIngredient.EMPTY) {
                throw new IllegalStateException("Cannot set both part and ingredient");
            }
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new PartSwappingOverrideRecipe(id, this.tools, this.maxStackSize, this.part, indices), PartSwappingOverrideRecipe.LOADER, null));
        } else {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new FixedMaterialSwappingRecipe(id, this.tools, this.maxStackSize, this.ingredient, this.material, indices, this.repairValue), FixedMaterialSwappingRecipe.LOADER, null));
        }
    }

    private MaterialSwappingRecipeBuilder(Ingredient tools) {
        this.tools = tools;
    }

    public static MaterialSwappingRecipeBuilder tools(Ingredient tools) {
        return new MaterialSwappingRecipeBuilder(tools);
    }

    public MaterialSwappingRecipeBuilder maxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public MaterialSwappingRecipeBuilder part(IToolPart part) {
        this.part = part;
        return this;
    }

    public MaterialSwappingRecipeBuilder repairValue(int repairValue) {
        this.repairValue = repairValue;
        return this;
    }
}

