/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public abstract class MaterialSwappingRecipe
implements ITinkerStationRecipe {
    protected static final RecordField<Ingredient, MaterialSwappingRecipe> TOOLS_FIELD = IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.tools);
    protected static final RecordField<Integer, MaterialSwappingRecipe> STACK_SIZE_FIELD = IntLoadable.FROM_ONE.defaultField("max_stack_size", (Object)16, true, r -> r.maxStackSize);
    protected static final RecipeResult<LazyToolStack> TOO_FEW_INPUTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_few_inputs"), new Object[0]);
    protected static final RecipeResult<LazyToolStack> TOO_FEW_PARTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_few_parts"), new Object[0]);
    protected static final RecipeResult<LazyToolStack> TOO_MANY_PARTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected static final RecipeResult<LazyToolStack> INVALID_MATERIAL = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.invalid_material"), new Object[0]);
    protected final ResourceLocation id;
    protected final Ingredient tools;
    protected final int maxStackSize;

    @Override
    public int shrinkToolSlotBy() {
        return this.maxStackSize;
    }

    protected static int maxStackSize(IToolStackView tool, float count) {
        for (ModifierEntry entry : tool.getModifiers()) {
            count = entry.getHook(ModifierHooks.CRAFT_COUNT).modifyCraftCount(tool, entry, count);
            if (!(count <= 0.0f)) continue;
            return 0;
        }
        return (int)count;
    }

    protected int maxStackSize(IToolStackView tool) {
        return MaterialSwappingRecipe.maxStackSize(tool, this.maxStackSize);
    }

    @Override
    public int shrinkToolSlotBy(LazyToolStack result, ITinkerStationContainer inv) {
        int outputMax = this.maxStackSize(result.getTool());
        return MaterialSwappingRecipe.maxStackSize(inv.getTinkerable(), (float)(result.getSize() * this.maxStackSize) / (float)outputMax);
    }

    protected RecipeResult<LazyToolStack> swapMaterial(ITinkerableContainer inv, MaterialVariantId material, int index, int partValue) {
        Component error;
        ToolStack original = inv.getTinkerable();
        int shrink = this.maxStackSize(original);
        if (shrink <= 0) {
            return TOO_FEW_INPUTS;
        }
        List<MaterialStatsId> statTypes = ToolMaterialHook.stats(original.getDefinition());
        if (index >= statTypes.size()) {
            return TOO_FEW_PARTS;
        }
        MaterialVariant toolMaterial = original.getMaterial(index);
        boolean didChange = !toolMaterial.sameVariant(material);
        float repairDurability = 0.0f;
        if (partValue > 0) {
            repairDurability = partValue * MaterialRepairModule.getDurability(null, material.getId(), statTypes.get(index));
        }
        if (!(didChange || original.getDamage() != 0 && repairDurability != 0.0f)) {
            return RecipeResult.pass();
        }
        ToolStack copy = original.copy();
        if (didChange) {
            copy.replaceMaterial(index, material);
        }
        if (repairDurability > 0.0f) {
            if ((repairDurability /= 3.0f) > 0.0f) {
                ModifierEntry entry;
                Iterator<ModifierEntry> iterator = copy.getModifierList().iterator();
                while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(copy, entry, repairDurability)) <= 0.0f)) {
                }
            }
            if (repairDurability > 0.0f) {
                ToolDamageUtil.repair(copy, (int)repairDurability);
            }
        }
        if ((error = copy.tryValidate()) != null) {
            return RecipeResult.failure(error);
        }
        if (didChange && (error = ModifierRemovalHook.onRemoved(original, copy)) != null) {
            return RecipeResult.failure(error);
        }
        ItemStack originalStack = inv.getTinkerableStack();
        int outputMax = this.maxStackSize(copy);
        int resultSize = Math.min(originalStack.m_41613_() * outputMax / shrink, outputMax);
        if (resultSize <= 0) {
            return TOO_FEW_INPUTS;
        }
        return LazyToolStack.successCopy(copy, resultSize, originalStack);
    }

    protected MaterialSwappingRecipe(ResourceLocation id, Ingredient tools, int maxStackSize) {
        this.id = id;
        this.tools = tools;
        this.maxStackSize = maxStackSize;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

