/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.IntArrayLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.MaterialSwappingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.tables.TinkerTables;

public class FixedMaterialSwappingRecipe
extends MaterialSwappingRecipe {
    public static final RecordLoadable<FixedMaterialSwappingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)TOOLS_FIELD, (RecordField)STACK_SIZE_FIELD, (RecordField)SizedIngredient.LOADABLE.requiredField("ingredient", r -> r.ingredient), (RecordField)MaterialVariantId.LOADABLE.requiredField("material", r -> r.material), (RecordField)new IntArrayLoadable((Loadable)IntLoadable.FROM_ZERO, -1, 10).requiredField("index", r -> r.indices), (RecordField)IntLoadable.FROM_ZERO.defaultField("repair_value", (Object)0, false, r -> r.repairValue), FixedMaterialSwappingRecipe::new);
    private final SizedIngredient ingredient;
    private final MaterialVariantId material;
    private final int[] indices;
    private final int repairValue;

    protected FixedMaterialSwappingRecipe(ResourceLocation id, Ingredient tools, int maxStackSize, SizedIngredient ingredient, MaterialVariantId material, int[] indices, int repairValue) {
        super(id, tools, maxStackSize);
        this.ingredient = ingredient;
        this.material = material;
        this.indices = indices;
        this.repairValue = repairValue;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !this.tools.test(tinkerable)) {
            return false;
        }
        List<MaterialStatsId> materials = ToolMaterialHook.stats(IModifiable.getToolDefinition(tinkerable.m_41720_()));
        if (this.indices[0] >= materials.size()) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_41619_()) continue;
            if (found || !this.ingredient.test(input)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        List<MaterialStatsId> materials = ToolMaterialHook.stats(inv.getTinkerable().getDefinition());
        if (materials.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            int index = this.indices[0];
            for (int j = 1; j < this.indices.length; ++j) {
                if (this.indices[j] != i) continue;
                index = i;
                break;
            }
            if (MaterialRegistry.getInstance().getMaterialStats(this.material.getId(), materials.get(index)).isEmpty()) {
                return INVALID_MATERIAL;
            }
            return this.swapMaterial(inv, this.material, index, this.repairValue);
        }
        return RecipeResult.pass();
    }

    @Override
    public void updateInputs(LazyToolStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            inv.shrinkInput(i, this.ingredient.getAmountNeeded());
            break;
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.fixedMaterialSwapping.get();
    }
}

