/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipe
implements IMeltingRecipe,
IMultiRecipe<MeltingRecipe> {
    public static final RecordLoadable<MaterialMeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)MaterialVariantId.LOADABLE.requiredField("input", r -> r.input.getVariant()), (RecordField)IntLoadable.FROM_ONE.requiredField("temperature", r -> r.temperature), (RecordField)FluidOutput.Loadable.REQUIRED.requiredField("result", r -> r.result), (RecordField)FluidOutput.Loadable.REQUIRED.list(0).defaultField("byproducts", List.of(), false, r -> r.byproducts), MaterialMeltingRecipe::new);
    private final ResourceLocation id;
    private final MaterialVariant input;
    private final int temperature;
    private final FluidOutput result;
    private final List<FluidOutput> byproducts;
    private List<MeltingRecipe> multiRecipes = null;

    public MaterialMeltingRecipe(ResourceLocation id, MaterialVariantId input, int temperature, FluidOutput result, List<FluidOutput> byproducts) {
        this.id = id;
        this.input = MaterialVariant.of(input);
        this.temperature = temperature;
        this.result = result;
        this.byproducts = byproducts;
    }

    @Deprecated(forRemoval=true)
    public MaterialMeltingRecipe(ResourceLocation id, MaterialVariantId input, int temperature, FluidOutput result) {
        this(id, input, temperature, result, List.of());
    }

    public boolean matches(IMeltingContainer inv, Level worldIn) {
        if (this.input.isUnknown()) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (stack.m_41619_() || MaterialCastingLookup.getItemCost(stack.m_41720_()) == 0) {
            return false;
        }
        return this.input.matchesVariant(stack);
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().m_41720_());
        return IMeltingRecipe.calcTimeForAmount(this.temperature, this.result.getAmount() * cost);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().m_41720_());
        return new FluidStack(this.result.get(), this.result.getAmount() * cost);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        if (!this.byproducts.isEmpty()) {
            int cost = MaterialCastingLookup.getItemCost(inv.getStack().m_41720_());
            for (FluidOutput byproduct : this.byproducts) {
                handler.fill(new FluidStack(byproduct.get(), byproduct.getAmount() * cost), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.materialMeltingSerializer.get();
    }

    public List<MeltingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            if (this.input.get().isHidden()) {
                this.multiRecipes = Collections.emptyList();
            } else {
                MaterialVariantId inputId = this.input.getVariant();
                this.multiRecipes = MaterialCastingLookup.getAllItemCosts().stream().filter(entry -> ((IMaterialItem)entry.getKey()).canUseMaterial(inputId.getId())).map(entry -> {
                    FluidOutput output = this.result;
                    List<FluidOutput> byproducts = this.byproducts;
                    int cost = entry.getIntValue();
                    if (cost != 1) {
                        output = FluidOutput.fromStack((FluidStack)new FluidStack(output.get(), output.getAmount() * cost));
                        if (!byproducts.isEmpty()) {
                            byproducts = byproducts.stream().map(fluid -> FluidOutput.fromStack((FluidStack)new FluidStack(fluid.get(), fluid.getAmount() * cost))).toList();
                        }
                    }
                    return new MeltingRecipe(this.id, "", (Ingredient)MaterialIngredient.of((ItemLike)entry.getKey(), inputId), output, this.temperature, IMeltingRecipe.calcTimeForAmount(this.temperature, output.getAmount()), byproducts, false);
                }).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

