/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialsCraftingTableRecipe;
import slimeknights.tconstruct.library.recipe.material.ShapedMaterialsRecipe;
import slimeknights.tconstruct.tables.TinkerTables;

public class ShapelessMaterialsRecipe
extends ShapelessRecipe
implements MaterialsCraftingTableRecipe {
    private final int partCount;
    private final List<MaterialVariantId> extraMaterials;

    public ShapelessMaterialsRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int partCount, List<MaterialVariantId> extraMaterials) {
        super(id, group, category, result, ingredients);
        this.partCount = partCount;
        this.extraMaterials = extraMaterials;
    }

    public ShapelessMaterialsRecipe(ShapelessRecipe recipe, int partCount, List<MaterialVariantId> extraMaterials) {
        this(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245232_(), recipe.f_44243_, (NonNullList<Ingredient>)recipe.m_7527_(), partCount, extraMaterials);
    }

    @Override
    public List<Ingredient> getParts() {
        return this.m_7527_();
    }

    @Override
    public void setMaterial(ItemStack stack, MaterialVariantId material) {
        ShapedMaterialsRecipe.setMaterial(stack, material, this.extraMaterials);
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        return ShapedMaterialsRecipe.assemble(super.m_5874_(inventory, registryAccess), inventory, (List<Ingredient>)this.m_7527_(), this.partCount, false, this.extraMaterials);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.shapelessMaterialsRecipeSerializer.get();
    }

    @Override
    public int getPartCount() {
        return this.partCount;
    }

    @Override
    public List<MaterialVariantId> getExtraMaterials() {
        return this.extraMaterials;
    }

    public static class Serializer
    implements LoggingRecipeSerializer<ShapelessMaterialsRecipe> {
        static final Loadable<List<MaterialVariantId>> EXTRA_MATERIALS = ShapedMaterialsRecipe.Serializer.EXTRA_MATERIALS;
        static final LoadableField<List<MaterialVariantId>, ShapelessMaterialsRecipe> MATERIAL_FIELD = EXTRA_MATERIALS.defaultField("extra_materials", List.of(), r -> r.extraMaterials);

        public ShapelessMaterialsRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe vanilla = (ShapelessRecipe)f_44077_.m_6729_(recipeId, json);
            int parts = GsonHelper.m_13927_((JsonObject)json, (String)"parts");
            if (parts < 1 || parts > vanilla.m_7527_().size()) {
                throw new JsonSyntaxException("Parts must be between 1 and the number of ingredients " + vanilla.m_7527_().size());
            }
            return new ShapelessMaterialsRecipe(vanilla, parts, (List)MATERIAL_FIELD.get(json));
        }

        @Nullable
        public ShapelessMaterialsRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe recipe = (ShapelessRecipe)f_44077_.m_8005_(recipeId, buffer);
            return recipe == null ? null : new ShapelessMaterialsRecipe(recipe, buffer.readByte(), (List)MATERIAL_FIELD.decode(buffer));
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ShapelessMaterialsRecipe recipe) {
            f_44077_.m_6178_(buffer, (Recipe)recipe);
            buffer.writeByte(recipe.partCount);
            MATERIAL_FIELD.encode(buffer, (Object)recipe);
        }
    }
}

