/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.util;

import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ModifierCondition<T extends IToolContext>(IJsonPredicate<T> tool, IntRange modifierLevel) {
    public static final ModifierCondition<IToolContext> ANY_CONTEXT = new ModifierCondition<IToolContext>(ToolContextPredicate.ANY, ModifierEntry.VALID_LEVEL);
    public static final ModifierCondition<IToolStackView> ANY_TOOL = new ModifierCondition<IToolStackView>(ToolStackPredicate.ANY, ModifierEntry.VALID_LEVEL);
    public static final RecordLoadable<ModifierCondition<IToolContext>> CONTEXT_LOADABLE = RecordLoadable.create((RecordField)ToolContextPredicate.LOADER.defaultField("tool", ModifierCondition::tool), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", ModifierCondition::modifierLevel), ModifierCondition::new);
    public static final RecordLoadable<ModifierCondition<IToolStackView>> TOOL_LOADABLE = RecordLoadable.create((RecordField)ToolStackPredicate.LOADER.defaultField("tool", ModifierCondition::tool), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", ModifierCondition::modifierLevel), ModifierCondition::new);
    public static final RecordField<ModifierCondition<IToolContext>, ConditionalModule<IToolContext>> CONTEXT_FIELD = CONTEXT_LOADABLE.directField(ConditionalModule::condition);
    public static final RecordField<ModifierCondition<IToolStackView>, ConditionalModule<IToolStackView>> TOOL_FIELD = TOOL_LOADABLE.directField(ConditionalModule::condition);

    public boolean matches(T tool, ModifierEntry modifier) {
        return this.modifierLevel.test(modifier.getLevel()) && this.tool.matches(tool);
    }

    public ModifierCondition<T> with(IJsonPredicate<T> tool) {
        return new ModifierCondition<T>(tool, this.modifierLevel);
    }

    public ModifierCondition<T> with(IntRange modifierLevel) {
        return new ModifierCondition<T>(this.tool, modifierLevel);
    }

    public ModifierCondition<T> minLevel(int level) {
        return this.with(ModifierEntry.VALID_LEVEL.min(level));
    }

    public ModifierCondition<T> maxLevel(int level) {
        return this.with(ModifierEntry.VALID_LEVEL.max(level));
    }

    public static interface ConditionalModule<T extends IToolContext> {
        public ModifierCondition<T> condition();
    }
}

