/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.data.loadable.LegacyLoadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.RandomLevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.BooleanPredicate;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public interface MobEffectModule
extends ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final RecordField<ModifierMobEffect, MobEffectModule> EFFECT_FIELD = ModifierMobEffect.LOADER.directField(MobEffectModule::effect);
    public static final RecordField<LevelingValue, MobEffectModule> CHANCE_FIELD = LevelingValue.LOADABLE.defaultField("chance", (Object)LevelingValue.ONE, MobEffectModule::chance);
    @Deprecated
    public static final RecordLoadable<Legacy> LOADER = LegacyLoadable.message((RecordLoadable)RecordLoadable.create(EFFECT_FIELD, WeaponCommon.BEFORE_MELEE_FIELD, (RecordField)LevelingValue.LOADABLE.defaultField("chance", (Object)LevelingValue.eachLevel(0.25f), MobEffectModule::chance), (RecordField)IntLoadable.FROM_ZERO.defaultField("counter_durability_usage", (Object)1, CounterCommon::durabilityUsage), ModifierCondition.TOOL_FIELD, Legacy::new), (String)"Using deprecated modifier module 'tconstruct:mob_effect'. Use one or both of 'tconstruct:weapon_mob_effect' or 'tconstruct:counter_mob_effect'");

    public ModifierMobEffect effect();

    default public LevelingValue chance() {
        return LevelingValue.ONE;
    }

    default public boolean checkChance(float level) {
        float chance = this.chance().compute(level);
        return chance > 0.0f && (chance >= 1.0f || TConstruct.RANDOM.nextFloat() < chance);
    }

    default public boolean checkChance(ModifierEntry entry) {
        return this.checkChance(entry.getEffectiveLevel());
    }

    public RecordLoadable<? extends MobEffectModule> getLoader();

    public static Builder builder(MobEffect effect) {
        return new Builder(effect);
    }

    public static Builder builder(Supplier<? extends MobEffect> effect) {
        return new Builder(effect.get());
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private final MobEffect effect;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private RandomLevelingValue level = RandomLevelingValue.flat(1.0f);
        private RandomLevelingValue time = RandomLevelingValue.flat(0.0f);
        @Nullable
        private LevelingValue chance = null;
        private boolean applyBeforeMelee = false;
        @Nullable
        private BooleanPredicate directDamage = null;
        private IJsonPredicate<DamageSource> damageSource = DamageSourcePredicate.ANY;
        private int counterDurabilityUsage = 1;
        private boolean targetSelf = false;
        private BooleanPredicate isAoe = BooleanPredicate.FALSE;
        private BooleanPredicate isProjectile = BooleanPredicate.FALSE;

        private ModifierMobEffect buildEffect() {
            return new ModifierMobEffect(this.effect, this.level, this.time, this.target);
        }

        public Weapon buildWeapon() {
            return new Weapon(this.buildEffect(), Objects.requireNonNullElse(this.chance, LevelingValue.ONE), this.holder, this.applyBeforeMelee, this.condition);
        }

        public ArmorCounter buildCounter() {
            return new ArmorCounter(this.buildEffect(), Objects.requireNonNullElse(this.chance, LevelingValue.eachLevel(0.15f)), this.holder, Objects.requireNonNullElse(this.directDamage, BooleanPredicate.TRUE), this.damageSource, this.counterDurabilityUsage, this.targetSelf, this.condition);
        }

        public ArmorAttack buildArmorAttack() {
            return new ArmorAttack(this.buildEffect(), Objects.requireNonNullElse(this.chance, LevelingValue.ONE), this.holder, Objects.requireNonNullElse(this.directDamage, BooleanPredicate.ALWAYS), this.damageSource, this.condition);
        }

        public ToolUsage buildToolUsage() {
            return new ToolUsage(this.buildEffect(), Objects.requireNonNullElse(this.chance, LevelingValue.ONE), this.isAoe, this.isProjectile, this.condition);
        }

        @Deprecated(forRemoval=true)
        public Legacy build() {
            return new Legacy(this.buildEffect(), this.applyBeforeMelee, Objects.requireNonNullElse(this.chance, LevelingValue.eachLevel(0.25f)), this.counterDurabilityUsage, this.condition);
        }

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        public Builder level(RandomLevelingValue level) {
            this.level = level;
            return this;
        }

        public Builder time(RandomLevelingValue time) {
            this.time = time;
            return this;
        }

        public Builder chance(@Nullable LevelingValue chance) {
            this.chance = chance;
            return this;
        }

        public Builder applyBeforeMelee(boolean applyBeforeMelee) {
            this.applyBeforeMelee = applyBeforeMelee;
            return this;
        }

        public Builder directDamage(@Nullable BooleanPredicate directDamage) {
            this.directDamage = directDamage;
            return this;
        }

        public Builder damageSource(IJsonPredicate<DamageSource> damageSource) {
            this.damageSource = damageSource;
            return this;
        }

        public Builder counterDurabilityUsage(int counterDurabilityUsage) {
            this.counterDurabilityUsage = counterDurabilityUsage;
            return this;
        }

        public Builder targetSelf(boolean targetSelf) {
            this.targetSelf = targetSelf;
            return this;
        }

        public Builder isAoe(BooleanPredicate isAoe) {
            this.isAoe = isAoe;
            return this;
        }

        public Builder isProjectile(BooleanPredicate isProjectile) {
            this.isProjectile = isProjectile;
            return this;
        }
    }

    public record ModifierMobEffect(MobEffect effect, RandomLevelingValue level, RandomLevelingValue time, IJsonPredicate<LivingEntity> target) {
        public static final RecordLoadable<ModifierMobEffect> LOADER = RecordLoadable.create((RecordField)Loadables.MOB_EFFECT.requiredField("effect", ModifierMobEffect::effect), (RecordField)RandomLevelingValue.LOADABLE.requiredField("level", ModifierMobEffect::level), (RecordField)RandomLevelingValue.LOADABLE.requiredField("time", ModifierMobEffect::time), (RecordField)LivingEntityPredicate.LOADER.defaultField("target", ModifierMobEffect::target), ModifierMobEffect::new);

        public void applyEffect(@Nullable LivingEntity target, float scaledLevel, @Nullable Entity cause) {
            if (target == null || !this.target.matches((Object)target)) {
                return;
            }
            int level = Math.round(this.level.computeValue(scaledLevel)) - 1;
            if (level < 0) {
                return;
            }
            float duration = this.time.computeValue(scaledLevel);
            if (duration > 0.0f) {
                target.m_147207_(new MobEffectInstance(this.effect, (int)duration, level), cause);
            }
        }

        public void applyEffect(@Nullable LivingEntity target, ModifierEntry entry, @Nullable Entity cause) {
            this.applyEffect(target, entry.getEffectiveLevel(), cause);
        }
    }

    @ApiStatus.Internal
    public static interface WeaponCommon
    extends Combat,
    MeleeHitModifierHook,
    MonsterMeleeHitModifierHook,
    ProjectileHitModifierHook {
        public static final RecordField<Boolean, WeaponCommon> BEFORE_MELEE_FIELD = BooleanLoadable.INSTANCE.defaultField("apply_before_melee", (Object)false, false, WeaponCommon::applyBeforeMelee);

        public boolean applyBeforeMelee();

        @Override
        default public void onMonsterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage) {
            if (context.isFullyCharged() && this.condition().matches(tool, modifier) && this.checkChance(modifier)) {
                LivingEntity attacker = context.getAttacker();
                if (this.holder().matches((Object)attacker)) {
                    this.effect().applyEffect(context.getLivingTarget(), modifier, (Entity)attacker);
                }
            }
        }

        @Override
        default public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
            if (this.applyBeforeMelee()) {
                this.onMonsterMeleeHit(tool, modifier, context, damage);
            }
            return knockback;
        }

        @Override
        default public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
            if (!this.applyBeforeMelee()) {
                this.onMonsterMeleeHit(tool, modifier, context, damageDealt);
            }
        }

        @Override
        default public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
            if (this.condition().modifierLevel().test(modifier.getLevel()) && TinkerPredicate.matches(this.holder(), attacker) && this.checkChance(modifier)) {
                this.effect().applyEffect(target, modifier, projectile.m_150173_());
            }
            return false;
        }
    }

    @Deprecated
    public record Legacy(ModifierMobEffect effect, boolean applyBeforeMelee, LevelingValue chance, int durabilityUsage, ModifierCondition<IToolStackView> condition) implements WeaponCommon,
    CounterCommon
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ON_ATTACKED, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_HIT);

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public RecordLoadable<Legacy> getLoader() {
            return LOADER;
        }

        @Override
        public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
            if (tool.hasTag(TinkerTags.Items.ARMOR)) {
                CounterCommon.super.onAttacked(tool, modifier, context, slotType, source, amount, isDirectDamage);
            }
        }
    }

    public record ToolUsage(ModifierMobEffect effect, LevelingValue chance, BooleanPredicate isAoe, BooleanPredicate isProjectile, ModifierCondition<IToolStackView> condition) implements MobEffectModule,
    BlockBreakModifierHook,
    MeleeHitModifierHook,
    MonsterMeleeHitModifierHook.RedirectAfter,
    ProjectileLaunchModifierHook,
    ProjectileHitModifierHook,
    PlantHarvestModifierHook,
    ShearsModifierHook,
    SlingLaunchModifierHook
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BLOCK_BREAK, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.PROJECTILE_THROWN, ModifierHooks.PROJECTILE_HIT, ModifierHooks.PLANT_HARVEST, ModifierHooks.SHEAR_ENTITY, ModifierHooks.SLING_LAUNCH);
        public static final RecordLoadable<ToolUsage> LOADER = RecordLoadable.create((RecordField)EFFECT_FIELD, (RecordField)CHANCE_FIELD, (RecordField)BooleanPredicate.LOADABLE.defaultField("is_aoe", (Object)BooleanPredicate.FALSE, ToolUsage::isAoe), (RecordField)BooleanPredicate.LOADABLE.defaultField("is_projectile", (Object)BooleanPredicate.FALSE, ToolUsage::isProjectile), ModifierCondition.TOOL_FIELD, ToolUsage::new);

        @Override
        public RecordLoadable<? extends MobEffectModule> getLoader() {
            return LOADER;
        }

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        @Override
        public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
            if (this.isAoe.test(context.isAOE()) && this.isProjectile.test(context.isProjectile()) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect(context.getLiving(), modifier, null);
            }
        }

        @Override
        public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
            if (context.isFullyCharged() && this.isAoe.test(context.isExtraAttack()) && this.isProjectile.test(context.isProjectile()) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect(context.getAttacker(), modifier, null);
            }
        }

        @Override
        public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
            if (this.isAoe.test(!primary) && this.isProjectile.test(false) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect(shooter, modifier, null);
            }
        }

        @Override
        public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, boolean notBlocked) {
            if (notBlocked && this.isAoe.test(false) && this.isProjectile.test(true) && this.condition.modifierLevel().test(modifier.getLevel()) && this.checkChance(modifier)) {
                this.effect.applyEffect(attacker, modifier, null);
            }
            return false;
        }

        @Override
        public boolean onProjectileHitsBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity owner) {
            if (this.isAoe.test(true) && this.isProjectile.test(true) && this.condition.modifierLevel().test(modifier.getLevel()) && this.checkChance(modifier)) {
                this.effect.applyEffect(owner, modifier, null);
            }
            return false;
        }

        @Override
        public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
            if (this.isAoe.test(false) && this.isProjectile.test(false) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect((LivingEntity)context.m_43723_(), modifier, null);
            }
        }

        @Override
        public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
            if (this.isAoe.test(!isTarget) && this.isProjectile.test(false) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect((LivingEntity)player, modifier, null);
            }
        }

        @Override
        public void afterSlingLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, LivingEntity target, ModifierEntry slingSource, float force, float multiplier, Vec3 angle) {
            if (this.isAoe.test(false) && this.isProjectile.test(false) && this.condition.matches(tool, modifier) && this.checkChance(modifier)) {
                this.effect.applyEffect(holder, modifier, null);
            }
        }
    }

    public record ArmorAttack(ModifierMobEffect effect, LevelingValue chance, IJsonPredicate<LivingEntity> holder, BooleanPredicate directDamage, IJsonPredicate<DamageSource> damageSource, ModifierCondition<IToolStackView> condition) implements Combat,
    DamageDealtModifierHook
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.DAMAGE_DEALT);
        public static final RecordLoadable<ArmorAttack> LOADER = RecordLoadable.create((RecordField)EFFECT_FIELD, (RecordField)CHANCE_FIELD, (RecordField)HOLDER_FIELD, (RecordField)BooleanPredicate.LOADABLE.defaultField("direct_damage", (Object)BooleanPredicate.ALWAYS, ArmorAttack::directDamage), (RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", ArmorAttack::damageSource), ModifierCondition.TOOL_FIELD, ArmorAttack::new);

        @Override
        public RecordLoadable<? extends MobEffectModule> getLoader() {
            return LOADER;
        }

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        @Override
        public void onDamageDealt(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, LivingEntity target, DamageSource source, float amount, boolean isDirectDamage) {
            LivingEntity holder;
            if (this.directDamage.test(isDirectDamage) && this.condition.matches(tool, modifier) && this.damageSource.matches((Object)source) && this.checkChance(modifier) && (holder = context.getEntity()) != target && this.holder.matches((Object)holder)) {
                this.effect.applyEffect(target, modifier, (Entity)holder);
            }
        }
    }

    public record ArmorCounter(ModifierMobEffect effect, LevelingValue chance, IJsonPredicate<LivingEntity> holder, BooleanPredicate directDamage, IJsonPredicate<DamageSource> damageSource, int durabilityUsage, boolean targetSelf, ModifierCondition<IToolStackView> condition) implements CounterCommon
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ON_ATTACKED);
        public static final RecordLoadable<ArmorCounter> LOADER = RecordLoadable.create((RecordField)EFFECT_FIELD, (RecordField)CHANCE_FIELD, (RecordField)HOLDER_FIELD, (RecordField)BooleanPredicate.LOADABLE.defaultField("direct_damage", (Object)BooleanPredicate.TRUE, ArmorCounter::directDamage), (RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", ArmorCounter::damageSource), (RecordField)IntLoadable.FROM_ZERO.defaultField("durability_usage", (Object)1, ArmorCounter::durabilityUsage), (RecordField)BooleanLoadable.INSTANCE.defaultField("target_self", (Object)false, false, ArmorCounter::targetSelf), ModifierCondition.TOOL_FIELD, ArmorCounter::new);

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public RecordLoadable<ArmorCounter> getLoader() {
            return LOADER;
        }
    }

    @ApiStatus.Internal
    public static interface CounterCommon
    extends Combat,
    OnAttackedModifierHook {
        public static final RecordField<LevelingValue, CounterCommon> CHANCE_FIELD = LevelingValue.LOADABLE.defaultField("chance", (Object)LevelingValue.eachLevel(0.15f), false, MobEffectModule::chance);

        public int durabilityUsage();

        default public boolean targetSelf() {
            return false;
        }

        default public BooleanPredicate directDamage() {
            return BooleanPredicate.TRUE;
        }

        default public IJsonPredicate<DamageSource> damageSource() {
            return DamageSourcePredicate.ANY;
        }

        @Override
        default public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
            if (this.directDamage().test(isDirectDamage) && this.condition().matches(tool, modifier) && this.damageSource().matches((Object)source)) {
                LivingEntity defender = context.getEntity();
                Entity sourceEntity = source.m_7639_();
                float scaledLevel = CounterModule.getLevel(tool, modifier, slotType, defender);
                if (sourceEntity != defender && this.checkChance(scaledLevel)) {
                    boolean applied = false;
                    if (this.targetSelf()) {
                        if (TinkerPredicate.matches(this.holder(), sourceEntity)) {
                            this.effect().applyEffect(defender, modifier, null);
                            applied = true;
                        }
                    } else if (this.holder().matches((Object)defender) && sourceEntity instanceof LivingEntity) {
                        LivingEntity attacker = (LivingEntity)sourceEntity;
                        this.effect().applyEffect(attacker, scaledLevel, (Entity)defender);
                        applied = true;
                    }
                    int durabilityUsage = this.durabilityUsage();
                    if (applied && durabilityUsage > 0) {
                        ToolDamageUtil.damageAnimated(tool, durabilityUsage, defender, slotType, modifier.getId());
                    }
                }
            }
        }
    }

    @ApiStatus.Internal
    public record Weapon(ModifierMobEffect effect, LevelingValue chance, IJsonPredicate<LivingEntity> holder, boolean applyBeforeMelee, ModifierCondition<IToolStackView> condition) implements WeaponCommon
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
        public static final RecordLoadable<Weapon> LOADER = RecordLoadable.create((RecordField)EFFECT_FIELD, (RecordField)CHANCE_FIELD, (RecordField)HOLDER_FIELD, (RecordField)BEFORE_MELEE_FIELD, ModifierCondition.TOOL_FIELD, Weapon::new);

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public RecordLoadable<? extends Weapon> getLoader() {
            return LOADER;
        }
    }

    public static interface Combat
    extends MobEffectModule {
        public static final RecordField<IJsonPredicate<LivingEntity>, Combat> HOLDER_FIELD = LivingEntityPredicate.LOADER.defaultField("holder", Combat::holder);

        default public IJsonPredicate<LivingEntity> holder() {
            return LivingEntityPredicate.ANY;
        }
    }
}

