/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.FormulaLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ProjectilePredicate;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record KnockbackModule(IJsonPredicate<LivingEntity> entity, ModifierFormula formula, ProjectilePredicate projectile, ModifierCondition<IToolStackView> condition) implements MeleeHitModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT);
    private static final FormulaLoadable FORMULA = new FormulaLoadable(ModifierFormula.FallbackFormula.ADD, "level", "knockback");
    public static final RecordLoadable<KnockbackModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("entity", KnockbackModule::entity), (RecordField)FORMULA.directField(KnockbackModule::formula), (RecordField)ProjectilePredicate.LOADABLE.defaultField("allow", (Object)ProjectilePredicate.ALWAYS, KnockbackModule::projectile), ModifierCondition.TOOL_FIELD, KnockbackModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        if (this.condition.matches(tool, modifier) && this.projectile.test(context.isProjectile()) && TinkerPredicate.matches(this.entity, context.getLivingTarget())) {
            return this.formula.apply(this.formula.processLevel(modifier), knockback);
        }
        return knockback;
    }

    public RecordLoadable<KnockbackModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModifierFormula.Builder<Builder, KnockbackModule> {
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;
        private ProjectilePredicate projectile = ProjectilePredicate.ALWAYS;

        private Builder() {
            super(FORMULA.variables());
        }

        @Override
        protected KnockbackModule build(ModifierFormula formula) {
            return new KnockbackModule(this.entity, formula, this.projectile, this.condition);
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }

        public Builder projectile(ProjectilePredicate projectile) {
            this.projectile = projectile;
            return this;
        }
    }
}

