/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record DurabilityShieldModule(int color, IJsonPredicate<ModifierId> cause) implements ModifierModule,
ToolDamageModifierHook,
DurabilityDisplayModifierHook
{
    private static final List<ModuleHook<?>> HOOKS = HookProvider.defaultHooks(ModifierHooks.TOOL_DAMAGE, ModifierHooks.DURABILITY_DISPLAY);
    private static final IJsonPredicate<ModifierId> ALLOW = ModifierPredicate.tag(TinkerTags.Modifiers.BYPASS_EXTRA_DURABILITY).inverted();
    public static final RecordLoadable<DurabilityShieldModule> LOADER = RecordLoadable.create((RecordField)ColorLoadable.NO_ALPHA.requiredField("color", DurabilityShieldModule::color), (RecordField)ModifierPredicate.LOADER.defaultField("cause", ALLOW, false, DurabilityShieldModule::cause), DurabilityShieldModule::new);

    public DurabilityShieldModule(int color) {
        this(color, ALLOW);
    }

    public RecordLoadable<DurabilityShieldModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return HOOKS;
    }

    public static int onDamageTool(CapacityBarHook bar, IToolStackView tool, ModifierEntry modifier, int amount) {
        int shield = bar.getAmount(tool);
        if (shield > 0) {
            if (shield >= amount) {
                bar.setAmount(tool, modifier, shield - amount);
                return 0;
            }
            amount -= shield;
            bar.setAmount(tool, modifier, 0);
        }
        return amount;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        return DurabilityShieldModule.onDamageTool(modifier.getHook(ModifierHooks.CAPACITY_BAR), tool, modifier, amount);
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder, @Nullable ItemStack stack, ModifierId cause) {
        if (this.cause.matches((Object)cause)) {
            return DurabilityShieldModule.onDamageTool(modifier.getHook(ModifierHooks.CAPACITY_BAR), tool, modifier, amount);
        }
        return amount;
    }

    @Override
    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        CapacityBarHook bar = modifier.getHook(ModifierHooks.CAPACITY_BAR);
        int shield = bar.getAmount(tool);
        if (shield > 0) {
            return DurabilityDisplayModifierHook.getWidthFor(shield, bar.getCapacity(tool, modifier));
        }
        return 0;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return modifier.getHook(ModifierHooks.CAPACITY_BAR).getAmount(tool) > 0 ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        if (modifier.getHook(ModifierHooks.CAPACITY_BAR).getAmount(tool) > 0) {
            return this.color;
        }
        return -1;
    }
}

