/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import slimeknights.mantle.data.loadable.IAmLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.mapping.EitherLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.MaterialRepairModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MaterialRepairModule
implements ModifierModule,
MaterialRepairModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>,
IAmLoadable.Record {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MATERIAL_REPAIR);
    private static final LoadableField<MaterialId, MaterialRepairModule> MATERIAL_FIELD = MaterialId.PARSER.requiredField("material", m -> m.material);
    private static final RecordLoadable<MaterialRepairModule> CONSTANT = RecordLoadable.create(MATERIAL_FIELD, (RecordField)IntLoadable.FROM_ONE.requiredField("durability", m -> m.repairAmount), ModifierCondition.TOOL_FIELD, MaterialRepairModule::new);
    private static final RecordLoadable<StatType> STAT_TYPE = RecordLoadable.create(MATERIAL_FIELD, (RecordField)MaterialStatsId.PARSER.requiredField("stat_type", m -> m.statType), ModifierCondition.TOOL_FIELD, StatType::new);
    public static final RecordLoadable<MaterialRepairModule> LOADER = EitherLoadable.record().key("durability", CONSTANT).key("stat_type", STAT_TYPE).build(CONSTANT);
    protected final MaterialId material;
    protected int repairAmount;
    private final ModifierCondition<IToolStackView> condition;

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<? extends MaterialRepairModule> getLoader() {
        return LOADER;
    }

    public RecordLoadable<? extends IAmLoadable.Record> loadable() {
        return CONSTANT;
    }

    @Override
    public boolean isRepairMaterial(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
        return this.material.equals(material) && this.condition().matches(tool, modifier);
    }

    protected int getRepairAmount(IToolStackView tool) {
        return this.repairAmount;
    }

    @Override
    public float getRepairAmount(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
        return this.isRepairMaterial(tool, modifier, material) ? (float)(this.getRepairAmount(tool) * modifier.getLevel()) : 0.0f;
    }

    public static Builder material(MaterialId material) {
        return new Builder(material);
    }

    private MaterialRepairModule(MaterialId material, int repairAmount, ModifierCondition<IToolStackView> condition) {
        this.material = material;
        this.repairAmount = repairAmount;
        this.condition = condition;
    }

    @Override
    public ModifierCondition<IToolStackView> condition() {
        return this.condition;
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private final MaterialId material;

        public MaterialRepairModule constant(int repairAmount) {
            return new MaterialRepairModule(this.material, repairAmount, this.condition);
        }

        public MaterialRepairModule statType(MaterialStatsId statType) {
            return new StatType(this.material, statType, (ModifierCondition<IToolStackView>)this.condition);
        }

        private Builder(MaterialId material) {
            this.material = material;
        }
    }

    static final class StatType
    extends MaterialRepairModule {
        private final MaterialStatsId statType;

        public StatType(MaterialId material, MaterialStatsId statType, ModifierCondition<IToolStackView> condition) {
            super(material, -1, condition);
            this.statType = statType;
        }

        @Override
        public RecordLoadable<? extends IAmLoadable.Record> loadable() {
            return STAT_TYPE;
        }

        @Override
        public int getRepairAmount(IToolStackView tool) {
            if (this.repairAmount == -1) {
                this.repairAmount = slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule.getDurability(tool.getDefinition().getId(), this.material, this.statType);
            }
            return this.repairAmount;
        }
    }
}

