/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.ItemStackLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public record EdibleModule(ItemStack representativeItem, LevelingInt duration, LevelingInt durabilityUsage, LevelingValue chance, ModifierCondition<IToolStackView> condition) implements ModifierModule,
GeneralInteractionModifierHook,
UsingToolModifierHook,
OnAttackedModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING, ModifierHooks.ON_ATTACKED);
    public static final RecordLoadable<EdibleModule> LOADER = RecordLoadable.create((RecordField)ItemStackLoadable.OPTIONAL_ITEM_NBT.defaultField("representative_item", (Object)ItemStack.f_41583_, EdibleModule::representativeItem), (RecordField)LevelingInt.LOADABLE.requiredField("duration", EdibleModule::duration), (RecordField)LevelingInt.LOADABLE.requiredField("durability_usage", EdibleModule::durabilityUsage), (RecordField)LevelingValue.LOADABLE.requiredField("counter_chance", EdibleModule::chance), ModifierCondition.TOOL_FIELD, EdibleModule::new);
    public static final FloatToolStat HUNGER = new FloatToolStat(new ToolStatId("tconstruct", "hunger"), -1005404, 0.0f, 0.0f, 200.0f, (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.INTERACTABLE_CHARGE), ItemPredicate.tag(TinkerTags.Items.ARMOR)}));
    public static final FloatToolStat SATURATION = new FloatToolStat(new ToolStatId("tconstruct", "saturation"), -1005404, 0.0f, 0.0f, 200.0f, (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.INTERACTABLE_CHARGE), ItemPredicate.tag(TinkerTags.Items.ARMOR)}));

    public EdibleModule(ItemLike representativeItem, LevelingInt duration, LevelingInt durabilityUsage, LevelingValue chance) {
        this(new ItemStack(representativeItem), duration, durabilityUsage, chance, ModifierCondition.ANY_TOOL);
    }

    public RecordLoadable<EdibleModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && player.m_36391_(false) && tool.getStats().getInt(HUNGER) > 0) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return this.duration.compute(modifier.getEffectiveLevel());
    }

    private void eat(IToolStackView tool, ModifierEntry modifier, Player player, ItemStack representativeItem) {
        StatsNBT stats = tool.getStats();
        int hunger = stats.getInt(HUNGER);
        if (hunger > 0) {
            Level world = player.m_9236_();
            float saturation = stats.get(SATURATION).floatValue();
            player.m_36324_().m_38707_(hunger, saturation);
            ModifierUtil.foodConsumer.onConsume(player, representativeItem, hunger, saturation);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            int damage = this.durabilityUsage.compute(modifier.getEffectiveLevel());
            if (damage > 0 && ToolDamageUtil.directDamage(tool, damage, (LivingEntity)player, player.m_21211_())) {
                player.m_21190_(player.m_7655_());
            }
        }
    }

    private ItemStack getRepresentativeItem(LivingEntity entity) {
        return !this.representativeItem.m_41619_() ? this.representativeItem : entity.m_21211_();
    }

    private static void eatEffects(LivingEntity entity, ItemStack representativeItem, int amount) {
        entity.m_21060_(representativeItem, amount);
        RandomSource random = entity.m_217043_();
        entity.m_5496_(SoundEvents.f_11912_, 0.5f + 0.5f * (float)random.m_188503_(2), (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        if (modifier != activeModifier && this.condition.matches(tool, modifier) && tool.getStats().getInt(HUNGER) > 0) {
            Player player;
            int useTime = useDuration - timeLeft;
            int duration = this.getUseDuration(tool, modifier);
            if (useTime == duration) {
                Player player2;
                if (entity instanceof Player && (player2 = (Player)entity).m_36391_(false)) {
                    ItemStack representativeItem = this.getRepresentativeItem(entity);
                    EdibleModule.eatEffects(entity, representativeItem, 16);
                    if (!entity.m_9236_().f_46443_) {
                        this.eat(tool, modifier, player2, representativeItem);
                    }
                }
            } else if (useTime < duration && useTime % 4 == 0 && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
                EdibleModule.eatEffects(entity, this.representativeItem, 5);
            }
        }
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        Player player;
        if (!tool.isBroken() && useDuration - timeLeft == this.getUseDuration(tool, modifier) && this.condition.matches(tool, modifier) && tool.getStats().getInt(HUNGER) > 0 && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            ItemStack representativeItem = this.getRepresentativeItem(entity);
            if (modifier != activeModifier) {
                EdibleModule.eatEffects(entity, representativeItem, 5);
            }
            if (!entity.m_9236_().f_46443_) {
                this.eat(tool, modifier, player, representativeItem);
            }
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (!tool.isBroken() && tool.hasTag(TinkerTags.Items.ARMOR) && this.condition.matches(tool, modifier) && tool.getStats().getInt(HUNGER) > 0) {
            Player player;
            LivingEntity entity = context.getEntity();
            float level = CounterModule.getLevel(tool, modifier, slotType, entity);
            if (context.getLevel().f_46441_.m_188501_() < this.chance.compute(level) && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
                this.eat(tool, modifier, player, !this.representativeItem.m_41619_() ? this.representativeItem : entity.m_6844_(slotType));
            }
        }
    }
}

