/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record EffectImmunityModule(MobEffect effect, ModifierCondition<IToolStackView> condition) implements ModifierModule,
EquipmentChangeModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE);
    public static final TinkerDataCapability.ComputableDataKey<Multiset<MobEffect>> EFFECT_IMMUNITY = TConstruct.createKey("effect_immunity", HashMultiset::create);
    public static final RecordLoadable<EffectImmunityModule> LOADER = RecordLoadable.create((RecordField)Loadables.MOB_EFFECT.requiredField("effect", EffectImmunityModule::effect), ModifierCondition.TOOL_FIELD, EffectImmunityModule::new);

    public EffectImmunityModule(MobEffect effect) {
        this(effect, ModifierCondition.ANY_TOOL);
    }

    public EffectImmunityModule(Supplier<? extends MobEffect> effect) {
        this(effect.get());
    }

    public RecordLoadable<EffectImmunityModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (!tool.isBroken() && ArmorLevelModule.validSlot(tool, context.getChangedSlot(), TinkerTags.Items.HELD_ARMOR) && this.condition.matches(tool, modifier)) {
            context.getTinkerData().ifPresent(data -> ((Multiset)data.computeIfAbsent(EFFECT_IMMUNITY)).add((Object)this.effect));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (!tool.isBroken() && ArmorLevelModule.validSlot(tool, context.getChangedSlot(), TinkerTags.Items.HELD_ARMOR) && this.condition.matches(tool, modifier)) {
            context.getTinkerData().ifPresent(data -> {
                Multiset<MobEffect> effects = data.get(EFFECT_IMMUNITY);
                if (effects != null) {
                    effects.remove((Object)this.effect);
                }
            });
        }
    }
}

