/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.protection.ProtectionFormula;
import slimeknights.tconstruct.library.json.variable.protection.ProtectionVariable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record AdjustDamageModule(ProtectionFormula formula, IJsonPredicate<LivingEntity> holder, IJsonPredicate<DamageSource> damageSource, float tooltipValue, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ModifyDamageModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    public static final RecordLoadable<AdjustDamageModule> LOADER = RecordLoadable.create((RecordField)ProtectionFormula.DAMAGE_LOADER.directField(AdjustDamageModule::formula), (RecordField)LivingEntityPredicate.LOADER.defaultField("holder", AdjustDamageModule::holder), (RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", AdjustDamageModule::damageSource), (RecordField)FloatLoadable.ANY.defaultField("tooltip_value", (Object)Float.valueOf(1.0f), true, AdjustDamageModule::tooltipValue), ModifierCondition.TOOL_FIELD, AdjustDamageModule::new);

    @Override
    public RecordLoadable<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return List.of();
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (this.condition.matches(tool, modifier) && this.holder.matches((Object)context.getEntity()) && this.damageSource.matches((Object)source)) {
            amount = this.formula.apply(tool, modifier, context, context.getEntity(), slotType, source, amount);
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float reduction;
        if (this.condition.matches(tool, entry) && TinkerPredicate.matchesInTooltip(this.holder, (LivingEntity)player, tooltipKey) && (reduction = this.formula.apply(tool, entry, null, (LivingEntity)(tooltipKey == TooltipKey.SHIFT ? player : null), null, null, this.tooltipValue) - this.tooltipValue) != 0.0f) {
            Modifier modifier = entry.getModifier();
            MutableComponent name = Component.m_237115_((String)(modifier.getTranslationKey() + ".damage_adjustment"));
            if (this.formula.percent()) {
                TooltipModifierHook.addPercentBoost(modifier, (Component)name, reduction, tooltip);
            } else {
                TooltipModifierHook.addFlatBoost(modifier, (Component)name, reduction, tooltip);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, AdjustDamageModule, ProtectionVariable> {
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private IJsonPredicate<DamageSource> source = DamageSourcePredicate.CAN_PROTECT;
        private float tooltipValue = 1.0f;

        private Builder() {
            super(ProtectionFormula.VARIABLES);
        }

        @SafeVarargs
        public final Builder sources(IJsonPredicate<DamageSource> ... sources) {
            return this.source((IJsonPredicate<DamageSource>)DamageSourcePredicate.and(sources));
        }

        @Override
        protected AdjustDamageModule build(ModifierFormula formula) {
            return new AdjustDamageModule(new ProtectionFormula(formula, this.variables, this.percent), this.holder, this.source, this.tooltipValue, this.condition);
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        public Builder source(IJsonPredicate<DamageSource> source) {
            this.source = source;
            return this;
        }

        public Builder tooltipValue(float tooltipValue) {
            this.tooltipValue = tooltipValue;
            return this;
        }
    }
}

