/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.build;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.helper.ModifierBuilder;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public interface ModifierTraitHook {
    public void addTraits(IToolContext var1, ModifierEntry var2, TraitBuilder var3, boolean var4);

    public record AllMerger(Collection<ModifierTraitHook> modules) implements ModifierTraitHook
    {
        @Override
        public void addTraits(IToolContext context, ModifierEntry modifier, TraitBuilder builder, boolean firstEncounter) {
            for (ModifierTraitHook module : this.modules) {
                module.addTraits(context, modifier, builder, firstEncounter);
            }
        }
    }

    public static class TraitBuilder
    implements ModifierBuilder {
        private final Set<Modifier> seenModifiers = new HashSet<Modifier>();
        private final Set<Modifier> currentStack = new LinkedHashSet<Modifier>();
        private final IToolContext context;
        private final ModifierNBT.Builder builder;

        @Override
        public TraitBuilder add(ModifierEntry entry) {
            if (entry.isBound()) {
                this.builder.add(entry);
                this.addTraits(entry);
            }
            return this;
        }

        private void addTraits(ModifierEntry entry) {
            Modifier modifier = entry.getModifier();
            ModifierTraitHook hook = modifier.getHooks().getOrNull(ModifierHooks.MODIFIER_TRAITS);
            if (hook != null) {
                if (this.currentStack.contains(modifier)) {
                    TConstruct.LOG.error("Encountered {} as a child of itself, previous stack {}", (Object)modifier.getId(), this.currentStack);
                } else {
                    this.currentStack.add(modifier);
                    hook.addTraits(this.context, entry, this, !this.hasSeenModifier(modifier));
                    this.seenModifiers.add(modifier);
                    this.currentStack.remove(modifier);
                }
            }
        }

        public boolean hasSeenModifier(Modifier modifier) {
            return this.seenModifiers.contains(modifier);
        }

        @Override
        public ModifierNBT build() {
            return this.builder.build();
        }

        public TraitBuilder(IToolContext context, ModifierNBT.Builder builder) {
            this.context = context;
            this.builder = builder;
        }
    }
}

