/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.block.MobEffectCloudFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.MobEffectFluidEffect;

public record FluidMobEffect(MobEffect effect, int time, int level, @Nullable List<Item> curativeItems) {
    private static final String TRANSLATION_ROOT = TConstruct.makeTranslationKey("fluid_effect", "mob_effect.");
    public static final RecordLoadable<FluidMobEffect> LOADABLE = RecordLoadable.create((RecordField)Loadables.MOB_EFFECT.requiredField("effect", e -> e.effect), (RecordField)IntLoadable.FROM_ONE.defaultField("time", (Object)-1, false, e -> e.time), (RecordField)IntLoadable.FROM_ONE.defaultField("level", (Object)1, true, e -> e.level), (RecordField)Loadables.ITEM.list(0).nullableField("curative_items", e -> e.curativeItems), FluidMobEffect::new);

    public FluidMobEffect(MobEffect effect, int time, int level) {
        this(effect, time, level, null);
    }

    public int amplifier() {
        return this.level - 1;
    }

    public boolean isInfinite() {
        return this.time == -1;
    }

    public MobEffectInstance effectWithTime(int time) {
        MobEffectInstance instance = new MobEffectInstance(this.effect, time, this.level - 1);
        if (this.curativeItems != null) {
            instance.setCurativeItems(this.curativeItems.stream().map(ItemStack::new).collect(Collectors.toList()));
        }
        return instance;
    }

    public MobEffectInstance makeEffect(float scale) {
        return this.effectWithTime((int)((float)this.time * scale));
    }

    public float apply(LivingEntity target, EffectLevel scale, TimeAction timeAction, IFluidHandler.FluidAction action) {
        return this.apply(target, scale, timeAction, action, null);
    }

    public float apply(LivingEntity target, EffectLevel scale, TimeAction timeAction, IFluidHandler.FluidAction action, @Nullable Entity source) {
        float used;
        int time;
        if (this.isInfinite() && !scale.isFull()) {
            return 0.0f;
        }
        if (this.isInfinite()) {
            time = this.time;
            used = 1.0f;
        } else {
            MobEffectInstance existingInstance = target.m_21124_(this.effect);
            int amplifier = this.amplifier();
            if (existingInstance != null && existingInstance.m_19564_() >= amplifier) {
                if (existingInstance.m_19564_() > amplifier) {
                    return 0.0f;
                }
                if (timeAction == TimeAction.ADD) {
                    int extraTime = (int)((float)this.time * scale.value());
                    if (extraTime <= 0) {
                        return 0.0f;
                    }
                    time = existingInstance.m_19557_() + extraTime;
                    used = scale.value();
                } else {
                    float existing = (float)existingInstance.m_19557_() / (float)this.time;
                    float effective = scale.effective(existing);
                    if (effective < existing) {
                        return 0.0f;
                    }
                    used = effective - existing;
                    time = (int)((float)this.time * effective);
                }
            } else {
                time = (int)((float)this.time * scale.value());
                used = scale.value();
            }
        }
        if (time != 0) {
            MobEffectInstance newInstance = this.effectWithTime(time);
            if (action.simulate()) {
                return target.m_7301_(newInstance) ? used : 0.0f;
            }
            return target.m_147207_(newInstance, source) ? used : 0.0f;
        }
        return 0.0f;
    }

    public Component getDisplayName(TimeAction action) {
        Component component = this.effect.m_19482_();
        if (this.level > 1) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + (this.level - 1)))});
        }
        if (this.isInfinite()) {
            return component;
        }
        return Component.m_237110_((String)(TRANSLATION_ROOT + action.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{this.time / 20, component});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<FluidMobEffect> effects = ImmutableList.builder();

        private Builder() {
        }

        public Builder effectCure(MobEffect effect, int time, int level, Item ... curativeItems) {
            this.effects.add((Object)new FluidMobEffect(effect, time, level, List.of(curativeItems)));
            return this;
        }

        public Builder effect(MobEffect effect, int time, int level) {
            this.effects.add((Object)new FluidMobEffect(effect, time, level, null));
            return this;
        }

        public Builder effect(MobEffect effect, int time) {
            return this.effect(effect, time, 1);
        }

        private List<FluidMobEffect> getEffects() {
            ImmutableList effects = this.effects.build();
            if (effects.isEmpty()) {
                throw new IllegalStateException("Must have at least one effect");
            }
            return effects;
        }

        public MobEffectCloudFluidEffect buildCloud() {
            return new MobEffectCloudFluidEffect(this.getEffects());
        }

        public List<MobEffectFluidEffect> buildEntity(TimeAction action) {
            return this.getEffects().stream().map(effect -> new MobEffectFluidEffect((FluidMobEffect)effect, action)).toList();
        }
    }
}

