/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.mining;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.data.loadable.mapping.ConditionalLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedVariable;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public final class LoadConditionMiningSpeedVariable
extends Record
implements MiningSpeedVariable,
ConditionalLoadable.ConditionalObject<MiningSpeedVariable> {
    private final MiningSpeedVariable ifTrue;
    private final MiningSpeedVariable ifFalse;
    private final ICondition[] conditions;

    public LoadConditionMiningSpeedVariable(MiningSpeedVariable ifTrue, MiningSpeedVariable ifFalse, ICondition ... conditions) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.conditions = conditions;
    }

    @Override
    public float getValue(IToolStackView tool, @Nullable PlayerEvent.BreakSpeed event, @Nullable Player player, @Nullable Direction sideHit) {
        return (Util.testConditions(this.conditions) ? this.ifTrue : this.ifFalse).getValue(tool, event, player, sideHit);
    }

    @Override
    public float getValue(IToolStackView tool, @Nullable BreakSpeedContext context, @Nullable Player player) {
        return (Util.testConditions(this.conditions) ? this.ifTrue : this.ifFalse).getValue(tool, context, player);
    }

    public RecordLoadable<? extends MiningSpeedVariable> getLoader() {
        return MiningSpeedVariable.LOADER.getConditionalLoader();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LoadConditionMiningSpeedVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LoadConditionMiningSpeedVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LoadConditionMiningSpeedVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this, o);
    }

    public MiningSpeedVariable ifTrue() {
        return this.ifTrue;
    }

    public MiningSpeedVariable ifFalse() {
        return this.ifFalse;
    }

    public ICondition[] conditions() {
        return this.conditions;
    }
}

