/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.block;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.loadable.mapping.ConditionalLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.variable.block.BlockVariable;
import slimeknights.tconstruct.library.utils.Util;

public final class LoadConditionBlockVariable
extends Record
implements BlockVariable,
ConditionalLoadable.ConditionalObject<BlockVariable> {
    private final BlockVariable ifTrue;
    private final BlockVariable ifFalse;
    private final ICondition[] conditions;

    public LoadConditionBlockVariable(BlockVariable ifTrue, BlockVariable ifFalse, ICondition ... conditions) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.conditions = conditions;
    }

    @Override
    public float getValue(BlockState block) {
        return (Util.testConditions(this.conditions) ? this.ifTrue : this.ifFalse).getValue(block);
    }

    @Override
    public RecordLoadable<? extends BlockVariable> getLoader() {
        return BlockVariable.LOADER.getConditionalLoader();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LoadConditionBlockVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LoadConditionBlockVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LoadConditionBlockVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this, o);
    }

    public BlockVariable ifTrue() {
        return this.ifTrue;
    }

    public BlockVariable ifFalse() {
        return this.ifFalse;
    }

    public ICondition[] conditions() {
        return this.conditions;
    }
}

