/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface SimpleFluidTank
extends IFluidTank,
IFluidHandler {
    default public int getTanks() {
        return 1;
    }

    public void setFluid(FluidStack var1);

    default public void updateFluid(FluidStack updated, int change) {
        if (change != 0) {
            this.setFluid(updated);
        }
    }

    default public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    @Nonnull
    default public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    default public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    default public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    default public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidStack fluid = this.getFluid();
        if (fluid.isEmpty()) {
            int amount = Math.min(this.getCapacity(), resource.getAmount());
            if (action.execute()) {
                this.updateFluid(new FluidStack(resource, amount), amount);
            }
            return amount;
        }
        if (!fluid.isFluidEqual(resource)) {
            return 0;
        }
        int capacity = this.getCapacity();
        int filled = Math.min(capacity - fluid.getAmount(), resource.getAmount());
        if (action.execute()) {
            fluid.grow(filled);
            this.updateFluid(fluid, filled);
        }
        return filled;
    }

    private FluidStack drain(FluidStack fluid, int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (fluid.getAmount() < drained) {
            drained = fluid.getAmount();
        }
        FluidStack result = new FluidStack(fluid, drained);
        if (action.execute()) {
            fluid.shrink(drained);
            this.updateFluid(fluid, -drained);
        }
        return result;
    }

    @Nonnull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluid();
        if (fluid.isEmpty() || !fluid.isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(fluid, resource.getAmount(), action);
    }

    @Nonnull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluid();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drain(fluid, maxDrain, action);
    }
}

