/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.datamap.RegistryDataMapLoader;
import slimeknights.mantle.data.listener.IEarlySafeManagerReloadListener;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialRenderInfoLoader
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialRenderInfoLoader.class);
    public static final MaterialRenderInfoLoader INSTANCE = new MaterialRenderInfoLoader();
    public static final String FOLDER = "tinkering/materials";
    private Map<MaterialVariantId, MaterialRenderInfo> renderInfos = ImmutableMap.of();

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, ModelEvent.RegisterAdditional.class, event -> {
            if (ModLoader.isLoadingStateValid()) {
                INSTANCE.onReloadSafe(Minecraft.m_91087_().m_91098_());
            }
        });
    }

    private MaterialRenderInfoLoader() {
    }

    public Collection<MaterialRenderInfo> getAllRenderInfos() {
        return this.renderInfos.values();
    }

    public Optional<MaterialRenderInfo> getRenderInfo(MaterialVariantId variantId) {
        MaterialRenderInfo info;
        if (variantId.hasVariant() && (info = this.renderInfos.get(variantId)) != null) {
            return Optional.of(info);
        }
        return Optional.ofNullable(this.renderInfos.get(variantId.getId()));
    }

    public static MaterialVariantId variant(ResourceLocation location) {
        String path = location.m_135815_();
        String variant = "";
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex >= 0) {
            variant = path.substring(slashIndex + 1);
            path = path.substring(0, slashIndex);
        }
        return MaterialVariantId.create(location.m_135827_(), path, variant);
    }

    public static TypedMap createContext(MaterialVariantId id) {
        return TypedMapBuilder.builder().put(MaterialVariantId.CONTEXT_KEY, (Object)id).put((TypedMap.Key)ContextKey.DEBUG, (Object)("Material Render Info " + id)).build();
    }

    public void onReloadSafe(ResourceManager manager) {
        HashMap jsons = new HashMap();
        SimpleJsonResourceReloadListener.m_278771_((ResourceManager)manager, (String)FOLDER, (Gson)JsonHelper.DEFAULT_GSON, jsons);
        HashMap<MaterialVariantId, MaterialRenderInfo> map = new HashMap<MaterialVariantId, MaterialRenderInfo>();
        for (Map.Entry entry : jsons.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            MaterialVariantId id = MaterialRenderInfoLoader.variant(location);
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)location.toString());
                if (json.keySet().isEmpty()) continue;
                map.put(id, (MaterialRenderInfo)RegistryDataMapLoader.parseData((String)"Material Render Info", jsons, (ResourceLocation)location, (JsonObject)json, null, MaterialRenderInfo.LOADABLE, (TypedMap)MaterialRenderInfoLoader.createContext(id)));
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                log.error("Couldn't parse data file {} from {}", (Object)id, (Object)location, (Object)ex);
            }
        }
        this.renderInfos = Map.copyOf(map);
        log.debug("Loaded material render infos: {}", (Object)Util.toIndentedStringList(map.keySet().stream().sorted(Comparator.comparing(MaterialVariantId::getId).thenComparing(MaterialVariantId::getVariant)).toList()));
        log.info("{} material render infos loaded", (Object)map.size());
    }
}

