/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.util;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractSpriteReader {
    protected final List<NativeImage> openedImages = new ArrayList<NativeImage>();

    public abstract boolean exists(ResourceLocation var1);

    public abstract boolean metadataExists(ResourceLocation var1);

    public abstract NativeImage read(ResourceLocation var1) throws IOException;

    @Nullable
    public NativeImage readIfExists(ResourceLocation path) {
        if (this.exists(path)) {
            try {
                return this.read(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract JsonObject readMetadata(ResourceLocation var1) throws IOException;

    public NativeImage create(int width, int height) {
        NativeImage image = new NativeImage(width, height, true);
        this.openedImages.add(image);
        return image;
    }

    public void track(NativeImage transformed) {
        this.openedImages.add(transformed);
    }

    public void closeAll() {
        for (NativeImage image : this.openedImages) {
            image.close();
        }
        this.openedImages.clear();
    }
}

