/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentPageIconList;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.util.DataLoadedConditionContext;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class TierRangeMaterialSectionTransformer
extends BookTransformer {
    private static final ResourceLocation KEY = TConstruct.getResource("material_tier");
    private static final IntRange TIER = new IntRange(0, Short.MAX_VALUE);
    private static final TypedMap CONTEXT = TypedMapBuilder.builder().put((TypedMap.Key)ContextKey.CONDITION_CONTEXT, (Object)DataLoadedConditionContext.INSTANCE).build();
    private static final Map<ResourceLocation, MaterialType> MATERIAL_TYPES = new HashMap<ResourceLocation, MaterialType>();
    public static final TierRangeMaterialSectionTransformer INSTANCE = new TierRangeMaterialSectionTransformer();

    public static void registerMaterialType(ResourceLocation id, BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> constructor, @Nullable Comparator<IMaterial> sortComparator, MaterialStatsId ... stats) {
        if (MATERIAL_TYPES.putIfAbsent(id, new MaterialType(constructor, (Set<MaterialStatsId>)ImmutableSet.copyOf((Object[])stats), sortComparator)) != null) {
            throw new IllegalArgumentException("Duplicate material stat group " + id);
        }
    }

    public static void registerMaterialType(ResourceLocation id, BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> constructor, MaterialStatsId ... stats) {
        TierRangeMaterialSectionTransformer.registerMaterialType(id, constructor, null, stats);
    }

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement element = (JsonElement)section.extraData.get(KEY);
            if (element == null) continue;
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)KEY.toString());
                IntRange tier = TIER.getOrDefault(json, "tier");
                IJsonPredicate<MaterialVariantId> predicate = MaterialPredicate.ANY;
                if (json.has("predicate")) {
                    predicate = (IJsonPredicate)MaterialPredicate.LOADER.getIfPresent(json, "predicate", CONTEXT);
                } else if (json.has("tag")) {
                    predicate = MaterialPredicate.tag((TagKey<IMaterial>)((TagKey)TinkerLoadables.MATERIAL_TAGS.getIfPresent(json, "tag")));
                }
                ResourceLocation type = JsonHelper.getResourceLocation((JsonObject)json, (String)"type");
                MaterialType typeData = MATERIAL_TYPES.get(type);
                if (typeData == null) {
                    throw new JsonSyntaxException("Invalid material section type " + type);
                }
                Function<MaterialVariantId, AbstractMaterialContent> pageBuilder = typeData.getMapping(GsonHelper.m_13855_((JsonObject)json, (String)"detailed", (boolean)false));
                TierRangeMaterialSectionTransformer.createPages(book, section, new ValidMaterial(typeData.visibleStats(), tier, predicate), pageBuilder, typeData.sortComparator);
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to parse material tier section data", (Throwable)e);
            }
        }
    }

    private static PageData createPage(SectionData data, String name, ResourceLocation type, PageContent content) {
        PageData page = new PageData(true);
        page.source = data.source;
        page.parent = data;
        page.name = name;
        page.type = type;
        page.content = content;
        page.load();
        return page;
    }

    @Deprecated(forRemoval=true)
    public static void createPages(BookData book, SectionData sectionData, Predicate<IMaterial> validMaterial, Function<MaterialVariantId, AbstractMaterialContent> pageCreator) {
        TierRangeMaterialSectionTransformer.createPages(book, sectionData, validMaterial, pageCreator, null);
    }

    public static void createPages(BookData book, SectionData sectionData, Predicate<IMaterial> validMaterial, Function<MaterialVariantId, AbstractMaterialContent> pageCreator, @Nullable Comparator<IMaterial> sortComparator) {
        List<IMaterial> materialList;
        sectionData.source = BookRepository.DUMMY;
        sectionData.parent = book;
        Stream<IMaterial> materialStream = MaterialRegistry.getMaterials().stream().filter(validMaterial);
        if (sortComparator != null) {
            materialStream = materialStream.sorted(sortComparator);
        }
        if ((materialList = materialStream.toList()).isEmpty()) {
            return;
        }
        List listPages = ContentPageIconList.getPagesNeededForItemCount((int)materialList.size(), (SectionData)sectionData, (String)book.translate(sectionData.name), (String)((String)book.strings.get(String.format("%s.subtext", sectionData.name))));
        ListIterator iter = listPages.listIterator();
        ContentPageIconList overview = (ContentPageIconList)iter.next();
        ArrayList<PageData> newPages = new ArrayList<PageData>(materialList.size());
        for (IMaterial material : materialList) {
            MaterialId materialId = material.getIdentifier();
            AbstractMaterialContent contentMaterial = pageCreator.apply(materialId);
            PageData page = TierRangeMaterialSectionTransformer.createPage(sectionData, materialId.toString(), contentMaterial.getId(), contentMaterial);
            newPages.add(page);
            ItemElement icon = new ItemElement(0, 0, 1.0f, contentMaterial.getDisplayStacks());
            while (!overview.addLink((SizedBookElement)icon, contentMaterial.getTitleComponent(), page)) {
                overview = (ContentPageIconList)iter.next();
            }
        }
        sectionData.pages.addAll(listPages.size(), newPages);
    }

    public static Function<IMaterial, Boolean> hasStatType(MaterialStatsId statType) {
        return mat -> MaterialRegistry.getInstance().getMaterialStats(mat.getIdentifier(), statType).isPresent();
    }

    public static Function<IMaterial, Boolean> hasStatType(IMaterialStats statType) {
        return TierRangeMaterialSectionTransformer.hasStatType(statType.getIdentifier());
    }

    public static Function<IMaterial, Integer> tagOrder(TagKey<IMaterial> tag) {
        return mat -> {
            List<IMaterial> values = MaterialRegistry.getInstance().getTagValues(tag);
            int index = values.indexOf(mat);
            return index == -1 ? values.size() : index;
        };
    }

    private record MaterialType(BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> pageConstructor, Set<MaterialStatsId> visibleStats, @Nullable Comparator<IMaterial> sortComparator) {
        public Function<MaterialVariantId, AbstractMaterialContent> getMapping(boolean detailed) {
            return id -> this.pageConstructor.apply((MaterialVariantId)id, detailed);
        }
    }

    public record ValidMaterial(Set<MaterialStatsId> visibleStats, IntRange tier, IJsonPredicate<MaterialVariantId> predicate) implements Predicate<IMaterial>
    {
        @Deprecated(forRemoval=true)
        public ValidMaterial(Set<MaterialStatsId> visibleStats, IntRange tier, TagKey<IMaterial> tag) {
            this(visibleStats, tier, MaterialPredicate.tag(tag));
        }

        @Override
        public boolean test(IMaterial material) {
            if (!this.tier.test(material.getTier())) {
                return false;
            }
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            MaterialId id = material.getIdentifier();
            if (!this.predicate.matches((Object)id)) {
                return false;
            }
            for (IMaterialStats stats : registry.getAllStats(id)) {
                if (!this.visibleStats.contains((Object)stats.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }
}

