/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.elements.FluidItemElement;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.utils.Util;

public class FluidEffectContent
extends PageContent {
    public static final transient ResourceLocation ID = TConstruct.getResource("fluid_effect");
    private static final transient String KEY_BLOCK_EFFECTS = TConstruct.makeTranslationKey("book", "fluid_effects.block");
    private static final transient String KEY_ENTITY_EFFECTS = TConstruct.makeTranslationKey("book", "fluid_effects.entity");
    @Nonnull
    protected String title = "";
    protected String group = "";
    protected String text = "";
    @Nullable
    protected String[] entity = null;
    @Nullable
    protected String[] block = null;
    private transient List<Component> entityComponents = List.of();
    private transient List<Component> blockComponents = List.of();
    private transient List<FluidStack> fluids = List.of();
    private transient List<ItemStack> fluidItems = List.of();

    public void loadEffectData(ResourceLocation name, FluidEffects effects, List<FluidStack> fluids, List<ItemStack> fluidItems) {
        ClientLevel level;
        this.fluids = fluids;
        this.fluidItems = fluidItems;
        String key = Util.makeTranslationKey("fluid", name);
        if (this.title.isBlank()) {
            this.title = ForgeI18n.getPattern((String)key);
        }
        if (this.text.isBlank()) {
            this.text = ForgeI18n.getPattern((String)(key + ".fluid_effect"));
        }
        if (effects.hasEffects() && (level = Minecraft.m_91087_().f_91073_) != null) {
            RegistryAccess access = level.m_9598_();
            if (effects.hasBlockEffects() && this.block == null) {
                this.blockComponents = effects.blockEffects().stream().map(effect -> effect.getDescription(access)).toList();
            }
            if (effects.hasEntityEffects() && this.entity == null) {
                this.entityComponents = effects.entityEffects().stream().map(effect -> effect.getDescription(access)).toList();
            }
        }
    }

    private void addList(ArrayList<BookElement> list, int x, int y, int height, String key, @Nullable String[] texts, List<Component> components) {
        if (texts != null || !components.isEmpty()) {
            TextData head = new TextData(I18n.m_118938_((String)key, (Object[])new Object[0]));
            head.underlined = true;
            list.add((BookElement)new TextElement(x, y, 182, height, new TextData[]{head}));
            if (texts == null) {
                ArrayList<TextComponentData> effectData = new ArrayList<TextComponentData>();
                for (Component text : components) {
                    effectData.add(new TextComponentData((Component)Component.m_237113_((String)"\u25cf ").m_7220_(text)).linebreak(true));
                }
                list.add((BookElement)new TextComponentElement(x, y + 14, 182, height, effectData));
            } else if (texts.length > 0) {
                ArrayList<TextData> effectData = new ArrayList<TextData>();
                for (String text : texts) {
                    effectData.add(new TextData("\u25cf " + text).linebreak(true));
                }
                list.add((BookElement)new TextElement(x, y + 14, 182, height, effectData));
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        this.addTitle(list, this.getTitle());
        int y = this.getTitleHeight();
        FluidItemElement fluid = new FluidItemElement(-2, y, 2.0f, this.fluidItems, this.fluids);
        list.add((BookElement)fluid);
        list.add((BookElement)new TextElement(fluid.width, y, 182 - fluid.width, fluid.height, this.text));
        int group = (176 - (y += fluid.height)) / 2;
        this.addList(list, 0, y, group, KEY_ENTITY_EFFECTS, this.entity, this.entityComponents);
        this.addList(list, 0, y + group, group, KEY_BLOCK_EFFECTS, this.block, this.blockComponents);
    }

    public void setTitle(@Nonnull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public String getGroup() {
        return this.group;
    }
}

