/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.FixedArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class DyedArmorTextureSupplier
implements ArmorTextureSupplier {
    public static final RecordLoadable<DyedArmorTextureSupplier> LOADER = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("prefix", s -> s.prefix), (RecordField)ModifierId.PARSER.defaultField("modifier", (Object)TinkerModifiers.dyed.getId(), s -> s.modifier), (RecordField)ColorLoadable.NO_ALPHA.nullableField("default_color", s -> s.alwaysRender ? Integer.valueOf(s.defaultColor) : null), (RecordField)IntLoadable.range((int)0, (int)15).defaultField("luminosity", (Object)0, false, s -> s.luminosity), DyedArmorTextureSupplier::new);
    private final ResourceLocation prefix;
    private final ModifierId modifier;
    private final boolean alwaysRender;
    private final int defaultColor;
    private final int luminosity;
    private final TintedArmorTexture[] textures;

    public DyedArmorTextureSupplier(ResourceLocation prefix, ModifierId modifier, @Nullable Integer defaultColor, int luminosity) {
        this.prefix = prefix;
        this.modifier = modifier;
        this.alwaysRender = defaultColor != null;
        this.defaultColor = Objects.requireNonNullElse(defaultColor, -1);
        this.luminosity = luminosity;
        this.textures = new TintedArmorTexture[]{FixedArmorTextureSupplier.getTexture(prefix, "armor", -1, luminosity), FixedArmorTextureSupplier.getTexture(prefix, "leggings", -1, luminosity), FixedArmorTextureSupplier.getTexture(prefix, "wings", -1, luminosity)};
    }

    public DyedArmorTextureSupplier(ResourceLocation prefix, ModifierId modifier, @Nullable Integer defaultColor) {
        this(prefix, modifier, defaultColor, 0);
    }

    public DyedArmorTextureSupplier(ResourceLocation base, String variant, ModifierId modifier, @Nullable Integer defaultColor) {
        this(base.m_266382_(variant), modifier, defaultColor);
    }

    @Override
    public ArmorTextureSupplier.ArmorTexture getArmorTexture(ItemStack stack, ArmorTextureSupplier.TextureType textureType, RegistryAccess access) {
        TintedArmorTexture texture = this.textures[textureType.ordinal()];
        if (texture != null && (this.alwaysRender || ModifierUtil.getModifierLevel(stack, this.modifier) > 0)) {
            int color = ModifierUtil.getPersistentInt(stack, this.modifier, this.defaultColor);
            return texture.color(0xFF000000 | color);
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public RecordLoadable<DyedArmorTextureSupplier> getLoader() {
        return LOADER;
    }
}

