/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import slimeknights.mantle.loot.function.RetexturedLootFunction;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;

public class BlockLootTableProvider
extends BlockLootSubProvider {
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    private static final LootItemCondition.Builder SILK_TOUCH_OR_SHEARS = SHEARS.m_285888_(SILK_TOUCH);
    private final LootItemFunction.Builder COPY_NAME = CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY);
    private final LootItemFunction.Builder COPY_MATERIAL = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Material", "Material");
    private final Function<Block, LootTable.Builder> ADD_TABLE = block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_(RetexturedLootFunction::new));
    private final Function<Block, LootTable.Builder> ADD_ANVIL = block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_(RetexturedLootFunction::new)).m_79078_(this.COPY_MATERIAL);

    protected BlockLootTableProvider() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.f_256975_.m_123024_().filter(block -> "tconstruct".equals(BuiltInRegistries.f_256975_.m_7981_(block).m_135827_())).collect(Collectors.toList());
    }

    protected void m_245660_() {
        this.addCommon();
        this.addDecorative();
        this.addGadgets();
        this.addWorld();
        this.addTools();
        this.addSmeltery();
        this.addFoundry();
    }

    private void addCommon() {
        this.registerFenceBuildingLootTables(TinkerMaterials.blazewood);
        this.registerFenceBuildingLootTables(TinkerMaterials.nahuatl);
        this.m_245724_((Block)TinkerCommons.cheeseBlock.get());
        this.m_245724_((Block)TinkerCommons.goldBars.get());
        this.m_245724_((Block)TinkerCommons.goldPlatform.get());
        this.m_245724_((Block)TinkerCommons.ironPlatform.get());
        this.m_245724_((Block)TinkerCommons.cobaltPlatform.get());
        TinkerCommons.copperPlatform.forEach(x$0 -> this.m_245724_((Block)x$0));
        TinkerCommons.waxedCopperPlatform.forEach(x$0 -> this.m_245724_((Block)x$0));
        this.m_245724_((Block)TinkerMaterials.cobalt.get());
        this.m_245724_((Block)TinkerMaterials.steel.get());
        this.m_245724_((Block)TinkerMaterials.slimesteel.get());
        this.m_245724_((Block)TinkerMaterials.amethystBronze.get());
        this.m_245724_((Block)TinkerMaterials.roseGold.get());
        this.m_245724_((Block)TinkerMaterials.pigIron.get());
        this.m_245724_((Block)TinkerMaterials.manyullyn.get());
        this.m_245724_((Block)TinkerMaterials.hepatizon.get());
        this.m_245724_((Block)TinkerMaterials.cinderslime.get());
        this.m_245724_((Block)TinkerMaterials.queensSlime.get());
        this.m_245724_((Block)TinkerMaterials.knightmetal.get());
        this.m_245724_((Block)TinkerMaterials.soulsteel.get());
        this.m_245724_((Block)TinkerMaterials.knightslime.get());
    }

    private void addDecorative() {
        this.m_245724_((Block)TinkerCommons.obsidianPane.get());
        this.m_245724_((Block)TinkerCommons.clearGlass.get());
        this.m_245724_((Block)TinkerCommons.clearTintedGlass.get());
        this.m_245724_((Block)TinkerCommons.clearGlassPane.get());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.m_245724_((Block)TinkerCommons.clearStainedGlass.get((Enum)color));
            this.m_245724_((Block)TinkerCommons.clearStainedGlassPane.get((Enum)color));
        }
        this.m_245724_((Block)TinkerCommons.soulGlass.get());
        this.m_245724_((Block)TinkerCommons.soulGlassPane.get());
    }

    private void addTools() {
        this.m_246481_((Block)TinkerTables.tinkersChest.get(), block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("color", "display.color"))));
        this.m_246481_((Block)TinkerTables.partChest.get(), block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME)));
        this.m_246481_((Block)TinkerTables.castChest.get(), block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Items", "TinkerData.Items"))));
        this.dropTable((Block)TinkerTables.craftingStation.get());
        this.dropTable((Block)TinkerTables.partBuilder.get());
        this.dropTable((Block)TinkerTables.tinkerStation.get());
        this.dropAnvil((Block)TinkerTables.tinkersAnvil.get());
        this.dropTable((Block)TinkerTables.modifierWorktable.get());
        this.dropAnvil((Block)TinkerTables.scorchedAnvil.get());
        this.m_246481_((Block)TinkerToolParts.fakeStorageBlock.get(), block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_MATERIAL)));
    }

    private void addWorld() {
        this.m_246481_((Block)TinkerWorld.cobaltOre.get(), block -> this.m_246109_((Block)block, TinkerWorld.rawCobalt.m_5456_()));
        this.m_245724_((Block)TinkerWorld.rawCobaltBlock.get());
        TinkerWorld.heads.forEach(x$0 -> this.m_245724_((Block)x$0));
        TinkerWorld.slime.forEach((type, block) -> {
            if (type != SlimeType.EARTH) {
                this.m_245724_((Block)block);
            }
        });
        TinkerWorld.congealedSlime.forEach((slime, block) -> this.m_247577_((Block)block, this.m_245142_((Block)block, (ItemLike)TinkerCommons.slimeball.get((Enum)slime), (NumberProvider)ConstantValue.m_165692_((float)4.0f))));
        TinkerWorld.slimeDirt.forEach(x$0 -> this.m_245724_((Block)x$0));
        TinkerWorld.vanillaSlimeGrass.forEach(block -> this.m_247577_((Block)block, this.m_245514_((Block)block, (ItemLike)Blocks.f_50493_)));
        TinkerWorld.earthSlimeGrass.forEach(block -> this.m_247577_((Block)block, this.m_245514_((Block)block, (ItemLike)TinkerWorld.slimeDirt.get((Enum)DirtType.EARTH))));
        TinkerWorld.skySlimeGrass.forEach(block -> this.m_247577_((Block)block, this.m_245514_((Block)block, (ItemLike)TinkerWorld.slimeDirt.get((Enum)DirtType.SKY))));
        TinkerWorld.enderSlimeGrass.forEach(block -> this.m_247577_((Block)block, this.m_245514_((Block)block, (ItemLike)TinkerWorld.slimeDirt.get((Enum)DirtType.ENDER))));
        TinkerWorld.ichorSlimeGrass.forEach(block -> this.m_247577_((Block)block, this.m_245514_((Block)block, (ItemLike)TinkerWorld.slimeDirt.get((Enum)DirtType.ICHOR))));
        TinkerWorld.slimeSapling.forEach((type, block) -> {
            if (type != FoliageType.ENDER) {
                this.m_245724_((Block)block);
            }
        });
        this.m_246481_((Block)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER), sapling -> (LootTable.Builder)this.m_246108_((ItemLike)sapling, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)sapling).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)MangrovePropaguleBlock.f_221441_, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)sapling)))));
        TinkerWorld.pottedSlimeSapling.forEach(x$0 -> this.m_246535_((Block)x$0));
        TinkerWorld.pottedSlimeFern.forEach(x$0 -> this.m_246535_((Block)x$0));
        TinkerWorld.slimeTallGrass.forEach(block -> this.m_246481_((Block)block, BlockLootTableProvider::onlyShears));
        for (FoliageType type2 : FoliageType.OVERWORLD) {
            this.m_246481_((Block)TinkerWorld.slimeLeaves.get((Enum)type2), block -> this.randomDropSlimeBallOrSapling(type2, (Block)block, (Block)TinkerWorld.slimeSapling.get((Enum)type2), f_244509_));
            this.m_246481_((Block)TinkerWorld.slimeFern.get((Enum)type2), BlockLootTableProvider::onlyShears);
        }
        for (FoliageType type2 : FoliageType.NETHER) {
            this.m_245724_((Block)TinkerWorld.slimeLeaves.get((Enum)type2));
            this.m_245724_((Block)TinkerWorld.slimeFern.get((Enum)type2));
        }
        this.m_246481_((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ENDER), leaves -> BlockLootTableProvider.droppingSilkOrShears(leaves, ((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)leaves, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])f_244531_))));
        this.m_246481_((Block)TinkerWorld.slimeFern.get((Enum)FoliageType.ENDER), BlockLootTableProvider::onlyShears);
        this.m_246481_((Block)TinkerWorld.skySlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.m_246481_((Block)TinkerWorld.enderSlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.registerWoodLootTables(TinkerWorld.greenheart);
        this.registerWoodLootTables(TinkerWorld.skyroot);
        this.registerWoodLootTables(TinkerWorld.bloodshroom);
        this.registerWoodLootTables(TinkerWorld.enderbark);
        this.m_245724_((Block)TinkerWorld.enderbarkRoots.get());
        TinkerWorld.slimyEnderbarkRoots.forEach(x$0 -> this.m_245724_((Block)x$0));
        this.registerCluster((Block)TinkerWorld.steelCluster.get(), (ItemLike)TinkerWorld.steelShard);
        this.registerCluster((Block)TinkerWorld.cobaltCluster.get(), (ItemLike)TinkerWorld.cobaltShard);
        this.registerCluster((Block)TinkerWorld.knightmetalCluster.get(), (ItemLike)TinkerWorld.knightmetalShard);
        this.registerGeode(TinkerWorld.earthGeode);
        this.registerGeode(TinkerWorld.skyGeode);
        this.registerGeode(TinkerWorld.ichorGeode);
        this.registerGeode(TinkerWorld.enderGeode);
    }

    private void addGadgets() {
        this.m_245724_((Block)TinkerGadgets.punji.get());
        TinkerGadgets.cake.forEach(block -> this.m_247577_((Block)block, BlockLootTableProvider.m_246386_()));
        this.m_247577_((Block)TinkerGadgets.magmaCake.get(), BlockLootTableProvider.m_246386_());
    }

    private void addSmeltery() {
        this.m_245724_((Block)TinkerSmeltery.grout.get());
        this.m_245724_((Block)TinkerSmeltery.searedMelter.get());
        this.m_245724_((Block)TinkerSmeltery.searedHeater.get());
        this.dropTable((Block)TinkerSmeltery.smelteryController.get());
        this.registerBuildingLootTables(TinkerSmeltery.searedStone);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedCobble);
        this.registerBuildingLootTables(TinkerSmeltery.searedPaver);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedBricks);
        this.m_245724_((Block)TinkerSmeltery.searedCrackedBricks.get());
        this.m_245724_((Block)TinkerSmeltery.searedFancyBricks.get());
        this.m_245724_((Block)TinkerSmeltery.searedTriangleBricks.get());
        this.m_245724_((Block)TinkerSmeltery.searedLamp.get());
        this.m_245724_((Block)TinkerSmeltery.searedLadder.get());
        this.m_245724_((Block)TinkerSmeltery.searedGlass.get());
        this.m_245724_((Block)TinkerSmeltery.searedSoulGlass.get());
        this.m_245724_((Block)TinkerSmeltery.searedTintedGlass.get());
        this.m_245724_((Block)TinkerSmeltery.searedGlassPane.get());
        this.m_245724_((Block)TinkerSmeltery.searedSoulGlassPane.get());
        this.dropTable((Block)TinkerSmeltery.searedDrain.get());
        this.dropTable((Block)TinkerSmeltery.searedChute.get());
        this.dropTable((Block)TinkerSmeltery.searedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("tank", "tank")));
        TinkerSmeltery.searedTank.forEach(block -> this.m_246481_((Block)block, dropTank));
        this.m_246481_((Block)TinkerSmeltery.searedFluidCannon.get(), dropTank);
        this.m_246481_((Block)TinkerSmeltery.scorchedFluidCannon.get(), dropTank);
        this.m_246481_((Block)TinkerSmeltery.searedLantern.get(), dropTank);
        this.m_246481_((Block)TinkerSmeltery.searedCastingTank.get(), dropTank);
        this.m_245724_((Block)TinkerSmeltery.searedFaucet.get());
        this.m_245724_((Block)TinkerSmeltery.searedChannel.get());
        this.m_245724_((Block)TinkerSmeltery.searedBasin.get());
        this.m_245724_((Block)TinkerSmeltery.searedTable.get());
        this.m_245724_((Block)TinkerSmeltery.copperGauge.get());
        this.m_245724_((Block)TinkerSmeltery.obsidianGauge.get());
    }

    private void addFoundry() {
        this.m_245724_((Block)TinkerSmeltery.netherGrout.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedAlloyer.get());
        this.dropTable((Block)TinkerSmeltery.foundryController.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedStone.get());
        this.m_245724_((Block)TinkerSmeltery.polishedScorchedStone.get());
        this.registerFenceBuildingLootTables(TinkerSmeltery.scorchedBricks);
        this.m_245724_((Block)TinkerSmeltery.chiseledScorchedBricks.get());
        this.registerBuildingLootTables(TinkerSmeltery.scorchedRoad);
        this.m_245724_((Block)TinkerSmeltery.scorchedLamp.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedLadder.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedGlass.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedSoulGlass.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedTintedGlass.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedGlassPane.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedSoulGlassPane.get());
        this.dropTable((Block)TinkerSmeltery.scorchedDrain.get());
        this.dropTable((Block)TinkerSmeltery.scorchedChute.get());
        this.dropTable((Block)TinkerSmeltery.scorchedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> this.droppingWithFunctions((Block)block, builder -> builder.m_79078_(this.COPY_NAME).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("tank", "tank")));
        TinkerSmeltery.scorchedTank.forEach(block -> this.m_246481_((Block)block, dropTank));
        this.m_246481_((Block)TinkerSmeltery.scorchedLantern.get(), dropTank);
        this.m_245724_((Block)TinkerSmeltery.scorchedFaucet.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedChannel.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedBasin.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedTable.get());
        this.m_245724_((Block)TinkerSmeltery.scorchedProxyTank.get());
    }

    protected static LootTable.Builder onlyShears(ItemLike item) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)));
    }

    private static LootTable.Builder droppingSilkOrShears(Block block, LootPoolEntryContainer.Builder<?> alternativeLootEntry) {
        return BlockLootTableProvider.m_246900_((Block)block, (LootItemCondition.Builder)SILK_TOUCH_OR_SHEARS, alternativeLootEntry);
    }

    private LootTable.Builder dropSapling(Block leaves, Block sapling, float ... fortune) {
        return BlockLootTableProvider.droppingSilkOrShears(leaves, ((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)leaves, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])fortune)));
    }

    private LootTable.Builder randomDropSlimeBallOrSapling(FoliageType foliageType, Block leaves, Block sapling, float ... fortune) {
        LootTable.Builder builder = this.dropSapling(leaves, sapling, fortune);
        SlimeType slime = foliageType.asSlime();
        if (slime != null) {
            return builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244248_).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)leaves, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)TinkerCommons.slimeball.get((Enum)slime))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.05f}))));
        }
        return builder;
    }

    private LootTable.Builder droppingWithFunctions(Block block, Function<LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> mapping) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)mapping.apply(LootItem.m_79579_((ItemLike)block)))));
    }

    private void registerBuildingLootTables(BuildingBlockObject object) {
        this.m_245724_((Block)object.get());
        this.m_246481_((Block)object.getSlab(), x$0 -> this.m_247233_((Block)x$0));
        this.m_245724_((Block)object.getStairs());
    }

    private void registerWallBuildingLootTables(WallBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.m_245724_((Block)object.getWall());
    }

    private void registerFenceBuildingLootTables(FenceBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.m_245724_((Block)object.getFence());
    }

    private void registerWoodLootTables(WoodBlockObject object) {
        this.registerFenceBuildingLootTables((FenceBuildingBlockObject)object);
        this.m_245724_(object.getLog());
        this.m_245724_(object.getStrippedLog());
        this.m_245724_(object.getWood());
        this.m_245724_(object.getStrippedWood());
        this.m_245724_((Block)object.getFenceGate());
        this.m_246481_((Block)object.getDoor(), x$0 -> this.m_247398_((Block)x$0));
        this.m_245724_((Block)object.getTrapdoor());
        this.m_245724_((Block)object.getPressurePlate());
        this.m_245724_((Block)object.getButton());
        this.m_245724_((Block)object.getSign());
        this.m_245724_((Block)object.getHangingSign());
    }

    private void dropTable(Block table) {
        this.m_246481_(table, this.ADD_TABLE);
    }

    private void dropAnvil(Block table) {
        this.m_246481_(table, this.ADD_ANVIL);
    }

    private void registerCluster(Block cluster, ItemLike drop) {
        this.m_246481_(cluster, block -> BlockLootTableProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_)))).m_7170_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))))));
    }

    private void registerGeode(GeodeItemObject geode) {
        this.m_245724_(geode.getBlock());
        this.registerCluster(geode.getBud(GeodeItemObject.BudSize.CLUSTER), (ItemLike)geode);
        for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.SIZES) {
            this.m_245644_(geode.getBud(size));
        }
        this.m_247577_(geode.getBudding(), BlockLootTableProvider.m_246386_());
    }
}

