/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.client.particle.SlimeParticle;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.client.SlimeskullArmorModel;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.client.DragonSkullModel;
import slimeknights.tconstruct.world.client.SkullModelHelper;
import slimeknights.tconstruct.world.client.SlimeColorReloadListener;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import slimeknights.tconstruct.world.client.TerracubeRenderer;
import slimeknights.tconstruct.world.client.TinkerSlimeRenderer;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldClientEvents
extends ClientEventBase {
    @SubscribeEvent
    static void addResourceListener(RegisterClientReloadListenersEvent event) {
        for (FoliageType type : FoliageType.values()) {
            event.registerReloadListener((PreparableReloadListener)new SlimeColorReloadListener(type));
        }
    }

    @SubscribeEvent
    static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)TinkerWorld.skySlimeParticle.get(), (ParticleProvider)new SlimeParticle.Factory(SlimeType.SKY));
        event.registerSpecial((ParticleType)TinkerWorld.enderSlimeParticle.get(), (ParticleProvider)new SlimeParticle.Factory(SlimeType.ENDER));
        event.registerSpecial((ParticleType)TinkerWorld.terracubeParticle.get(), (ParticleProvider)new SlimeParticle.Factory((ItemLike)Items.f_42461_));
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        Lazy normalHead = Lazy.of(SkullModel::m_170948_);
        Lazy headOverlayCustom = Lazy.of(() -> SkullModelHelper.createHeadHatLayer(0, 16, 32, 32));
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.BLAZE, (Supplier<LayerDefinition>)normalHead);
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.ENDERMAN, (Supplier<LayerDefinition>)Lazy.of(() -> SkullModelHelper.createHeadLayer(0, 0, 32, 16)));
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.STRAY, (Supplier<LayerDefinition>)headOverlayCustom);
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.HUSK, (Supplier<LayerDefinition>)Lazy.of(() -> SkullModelHelper.createHeadLayer(0, 0, 64, 64)));
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.DROWNED, (Supplier<LayerDefinition>)headOverlayCustom);
        Lazy spiderHead = Lazy.of(() -> SkullModelHelper.createHeadLayer(32, 4, 64, 32));
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.SPIDER, (Supplier<LayerDefinition>)spiderHead);
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.CAVE_SPIDER, (Supplier<LayerDefinition>)spiderHead);
        Lazy piglinHead = Lazy.of(() -> LayerDefinition.m_171565_((MeshDefinition)PiglinHeadModel.m_261259_(), (int)64, (int)64));
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.PIGLIN_BRUTE, (Supplier<LayerDefinition>)piglinHead);
        WorldClientEvents.registerLayerDefinition(event, TinkerHeadType.ZOMBIFIED_PIGLIN, (Supplier<LayerDefinition>)piglinHead);
    }

    @SubscribeEvent
    static void registerSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        EntityModelSet modelSet = event.getEntityModelSet();
        SkullModelHelper.HEAD_LAYERS.forEach((type, layer) -> {
            if (type.isPiglin()) {
                event.registerSkullModel((SkullBlock.Type)type, (SkullModelBase)new PiglinHeadModel(modelSet.m_171103_(layer)));
            } else {
                event.registerSkullModel((SkullBlock.Type)type, (SkullModelBase)new SkullModel(modelSet.m_171103_(layer)));
            }
        });
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(TinkerWorld.skySlimeEntity.get(), (EntityRendererProvider)TinkerSlimeRenderer.SKY_SLIME_FACTORY);
        event.registerEntityRenderer(TinkerWorld.enderSlimeEntity.get(), (EntityRendererProvider)TinkerSlimeRenderer.ENDER_SLIME_FACTORY);
        event.registerEntityRenderer(TinkerWorld.terracubeEntity.get(), TerracubeRenderer::new);
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            WorldClientEvents.registerHeadModel(TinkerHeadType.BLAZE, MaterialIds.blazingBone, new ResourceLocation("textures/entity/blaze.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.ENDERMAN, MaterialIds.enderPearl, TConstruct.getResource("textures/entity/skull/enderman.png"));
            SlimeskullArmorModel.registerHeadModel(MaterialIds.dragonScale, (EntityModelSet modelSet) -> new DragonSkullModel(modelSet.m_171103_(ModelLayers.f_171135_)), new ResourceLocation("textures/entity/enderdragon/dragon.png"));
            SlimeskullArmorModel.registerHeadModel(MaterialIds.glass, ModelLayers.f_171130_, new ResourceLocation("textures/entity/creeper/creeper.png"));
            SlimeskullArmorModel.registerHeadModel(MaterialIds.bone, ModelLayers.f_171240_, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
            SlimeskullArmorModel.registerHeadModel(MaterialIds.necroticBone, ModelLayers.f_171219_, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.STRAY, MaterialIds.venombone, TConstruct.getResource("textures/entity/skull/stray.png"));
            SlimeskullArmorModel.registerHeadModel(MaterialIds.leather, ModelLayers.f_171224_, new ResourceLocation("textures/entity/zombie/zombie.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.HUSK, MaterialIds.iron, new ResourceLocation("textures/entity/zombie/husk.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.DROWNED, MaterialIds.copper, TConstruct.getResource("textures/entity/skull/drowned.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.SPIDER, MaterialIds.string, new ResourceLocation("textures/entity/spider/spider.png"));
            WorldClientEvents.registerHeadModel(TinkerHeadType.CAVE_SPIDER, MaterialIds.darkthread, new ResourceLocation("textures/entity/spider/cave_spider.png"));
            SlimeskullArmorModel.registerPiglinHeadModel(MaterialIds.gold, ModelLayers.f_260668_, new ResourceLocation("textures/entity/piglin/piglin.png"));
            WorldClientEvents.registerPiglinHeadModel(TinkerHeadType.PIGLIN_BRUTE, MaterialIds.roseGold, new ResourceLocation("textures/entity/piglin/piglin_brute.png"));
            WorldClientEvents.registerPiglinHeadModel(TinkerHeadType.ZOMBIFIED_PIGLIN, MaterialIds.pigIron, new ResourceLocation("textures/entity/piglin/zombified_piglin.png"));
        });
    }

    @SubscribeEvent
    static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (FoliageType type : FoliageType.values()) {
            event.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), new Block[]{(Block)TinkerWorld.vanillaSlimeGrass.get((Enum)type), (Block)TinkerWorld.earthSlimeGrass.get((Enum)type), (Block)TinkerWorld.skySlimeGrass.get((Enum)type), (Block)TinkerWorld.enderSlimeGrass.get((Enum)type), (Block)TinkerWorld.ichorSlimeGrass.get((Enum)type)});
            event.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.slimeLeaves.get((Enum)type)});
            event.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), new Block[]{(Block)TinkerWorld.slimeFern.get((Enum)type), (Block)TinkerWorld.slimeTallGrass.get((Enum)type), (Block)TinkerWorld.pottedSlimeFern.get((Enum)type)});
        }
        event.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, FoliageType.SKY, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.skySlimeVine.get()});
        event.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, FoliageType.ENDER, SlimeColorizer.LOOP_OFFSET), new Block[]{(Block)TinkerWorld.enderSlimeVine.get()});
    }

    @SubscribeEvent
    static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.vanillaSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.earthSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.skySlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.enderSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.ichorSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeLeaves);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeFern);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.slimeTallGrass);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.skySlimeVine);
        WorldClientEvents.registerBlockItemColorAlias(blockColors, itemColors, TinkerWorld.enderSlimeVine);
    }

    private static int getSlimeColorByPos(@Nullable BlockPos pos, FoliageType type, @Nullable BlockPos add) {
        if (pos == null) {
            return type.getColor();
        }
        if (add != null) {
            pos = pos.m_121955_((Vec3i)add);
        }
        return SlimeColorizer.getColorForPos(pos, type);
    }

    private static void registerHeadModel(TinkerHeadType skull, MaterialId materialId, ResourceLocation texture) {
        SkullBlockRenderer.f_112519_.put(skull, texture);
        SlimeskullArmorModel.registerHeadModel(materialId, SkullModelHelper.HEAD_LAYERS.get((Object)skull), texture);
    }

    private static void registerPiglinHeadModel(TinkerHeadType skull, MaterialId materialId, ResourceLocation texture) {
        SkullBlockRenderer.f_112519_.put(skull, texture);
        SlimeskullArmorModel.registerPiglinHeadModel(materialId, SkullModelHelper.HEAD_LAYERS.get((Object)skull), texture);
    }

    private static ModelLayerLocation registerLayer(String name) {
        ModelLayerLocation location = new ModelLayerLocation(TConstruct.getResource(name), "main");
        if (!ModelLayers.f_171262_.add(location)) {
            throw new IllegalStateException("Duplicate registration for " + location);
        }
        return location;
    }

    private static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event, TinkerHeadType head, Supplier<LayerDefinition> supplier) {
        event.registerLayerDefinition(SkullModelHelper.HEAD_LAYERS.get((Object)head), supplier);
    }
}

