/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.AreaOfEffectHighlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public enum BrushModule implements ModifierModule,
GeneralInteractionModifierHook,
BlockInteractionModifierHook,
AreaOfEffectHighlightModifierHook
{
    INSTANCE;

    public static final RecordLoadable<BrushModule> LOADER;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;

    public RecordLoadable<BrushModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        return InteractionResult.PASS;
    }

    private static HitResult calculateHitResult(LivingEntity living) {
        return ProjectileUtil.m_278180_((Entity)living, entity -> !entity.m_5833_() && entity.m_6087_(), (double)living.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()));
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        Player player = context.m_43723_();
        if (source == InteractionSource.RIGHT_CLICK && player != null && BrushModule.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.BLOCK) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, context.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return ModifierUtil.blockWhileCharging(tool, UseAnim.BRUSH);
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 200;
    }

    private static void brushEffects(Player player, BlockHitResult blockHit, BlockState state, HumanoidArm arm, SoundEvent sound) {
        Level level = player.m_9236_();
        Item item = Items.f_271356_;
        if (item instanceof BrushItem) {
            BrushItem brush = (BrushItem)item;
            brush.m_278154_(level, blockHit, state, player.m_20252_(0.0f), arm);
        }
        level.m_247517_(player, blockHit.m_82425_(), sound, SoundSource.BLOCKS);
    }

    private static boolean brushBlock(Player player, BlockHitResult blockHit, BlockState state, HumanoidArm arm) {
        BrushableBlock brushable;
        Level level = player.m_9236_();
        Block block = state.m_60734_();
        if (block instanceof BrushableBlock) {
            brushable = (BrushableBlock)block;
            BrushModule.brushEffects(player, blockHit, state, arm, brushable.m_276856_());
            if (level.f_46443_) {
                return true;
            }
        }
        if (!level.f_46443_) {
            block = level.m_7702_(blockHit.m_82425_());
            return block instanceof BrushableBlockEntity && (brushable = (BrushableBlockEntity)block).m_276923_(level.m_46467_(), player, blockHit.m_82434_());
        }
        return false;
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        if (timeLeft >= 0 && entity instanceof Player) {
            Player player = (Player)entity;
            HitResult hit = BrushModule.calculateHitResult(entity);
            if (hit.m_6662_() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                if ((this.getUseDuration(tool, modifier) - timeLeft + 1) % 10 == 5) {
                    Level level = entity.m_9236_();
                    BlockPos pos = blockHit.m_82425_();
                    BlockState state = level.m_8055_(pos);
                    InteractionHand hand = entity.m_7655_();
                    HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
                    int damage = 0;
                    if (BrushModule.brushBlock(player, blockHit, state, arm)) {
                        ++damage;
                    }
                    UseOnContext context = new UseOnContext(level, player, hand, player.m_21120_(hand), blockHit);
                    for (BlockPos extraPos : tool.getDefinition().getHook(ToolHooks.AOE_ITERATOR).getBlocks(tool, context, state, AreaOfEffectIterator.AOEMatchType.TRANSFORM)) {
                        if (!BrushModule.brushBlock(player, Util.offset(blockHit, extraPos), level.m_8055_(extraPos), arm)) continue;
                        ++damage;
                    }
                    if (damage == 0 && level.f_46443_) {
                        BrushModule.brushEffects(player, blockHit, state, arm, SoundEvents.f_276624_);
                    }
                    if (damage > 0 && !level.f_46443_ && ToolDamageUtil.damageAnimated(tool, damage, entity, hand, modifier.getId())) {
                        entity.m_5810_();
                    }
                }
                return;
            }
        }
        entity.m_21253_();
    }

    @Override
    public boolean shouldHighlight(IToolStackView tool, ModifierEntry modifier, UseOnContext context, BlockPos offset, BlockState state) {
        return context.m_43725_().m_7702_(offset) instanceof BrushableBlockEntity;
    }

    static {
        LOADER = new SingletonLoader((Object)INSTANCE);
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.BLOCK_INTERACT, ModifierHooks.AOE_HIGHLIGHT);
    }
}

